/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.AbstractLdapHandler;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ExtendedResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;

public class ExtendedHandler
extends AbstractLdapHandler
implements MessageHandler {
    private Map<String, ExtendedOperationHandler> handlers = new HashMap<String, ExtendedOperationHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedOperationHandler addHandler(ExtendedOperationHandler eoh) {
        Map<String, ExtendedOperationHandler> map = this.handlers;
        synchronized (map) {
            return this.handlers.put(eoh.getOid(), eoh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedOperationHandler removeHandler(String oid) {
        Map<String, ExtendedOperationHandler> map = this.handlers;
        synchronized (map) {
            return this.handlers.remove(oid);
        }
    }

    public ExtendedOperationHandler getHandler(String oid) {
        return this.handlers.get(oid);
    }

    public Map getHandlerMap() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public void messageReceived(IoSession session, Object request) throws Exception {
        ExtendedRequest req = (ExtendedRequest)request;
        ExtendedOperationHandler handler = this.handlers.get(req.getOid());
        if (handler == null) {
            String msg = "Unrecognized extended operation EXTENSION_OID: " + req.getOid();
            LdapResult result = req.getResultResponse().getLdapResult();
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
        } else {
            try {
                SessionRegistry registry = SessionRegistry.getSingleton();
                handler.handleExtendedOperation(session, SessionRegistry.getSingleton(), req);
            }
            catch (Exception e) {
                LdapResult result = req.getResultResponse().getLdapResult();
                result.setResultCode(ResultCodeEnum.OTHER);
                result.setErrorMessage("Extended operation handler for the specified EXTENSION_OID (" + req.getOid() + ") has failed to process your request:\n" + ExceptionUtils.getStackTrace((Throwable)e));
                ExtendedResponse resp = (ExtendedResponse)req.getResultResponse();
                resp.setResponse(new byte[0]);
                session.write((Object)req.getResultResponse());
            }
        }
    }
}

