/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)BindHandler.class);
    private static final Control[] EMPTY = new Control[0];
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) {
        LdapContext ctx;
        BindRequest req = (BindRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        if (!req.getVersion3()) {
            result.setResultCode(ResultCodeEnum.PROTOCOLERROR);
            result.setErrorMessage("Only LDAP v3 is supported");
            session.write((Object)req.getResultResponse());
            return;
        }
        if (!req.isSimple()) {
            result.setResultCode(ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
            result.setErrorMessage("Only simple binds currently supported");
            session.write((Object)req.getResultResponse());
            return;
        }
        Hashtable env = SessionRegistry.getSingleton().getEnvironmentByCopy();
        byte[] creds = req.getCredentials();
        env.put("java.naming.security.principal", req.getName());
        env.put("java.naming.security.credentials", creds);
        env.put("java.naming.security.authentication", "simple");
        env.put("parsed.bind.dn", req.getName());
        if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "throw");
        }
        try {
            if (env.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)env.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(env);
            } else {
                Control[] connCtls = req.getControls().values().toArray(EMPTY);
                ctx = new InitialLdapContext(env, (javax.naming.ldap.Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getMessage();
            if (IS_DEBUG) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + req.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn((LdapDN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
            return;
        }
        SessionRegistry.getSingleton().setLdapContext(session, ctx);
        result.setResultCode(ResultCodeEnum.SUCCESS);
        session.write((Object)req.getResultResponse());
    }

    public void init(StartupConfiguration cfg) {
    }
}

