/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)CompareHandler.class);
    private static Control[] EMPTY_CONTROLS = new Control[0];
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) {
        CompareRequest req = (CompareRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            LdapContext ctx = SessionRegistry.getSingleton().getLdapContext(session, null, true);
            ServerLdapContext newCtx = (ServerLdapContext)ctx.lookup("");
            if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
                newCtx.addToEnvironment("java.naming.referral", (Object)"ignore");
            } else {
                newCtx.addToEnvironment("java.naming.referral", (Object)"throw");
            }
            newCtx.setRequestControls((javax.naming.ldap.Control[])req.getControls().values().toArray(EMPTY_CONTROLS));
            if (newCtx.compare(req.getName(), req.getAttributeId(), (Object)req.getAssertionValue())) {
                result.setResultCode(ResultCodeEnum.COMPARETRUE);
            } else {
                result.setResultCode(ResultCodeEnum.COMPAREFALSE);
            }
        }
        catch (ReferralException e) {
            ReferralImpl refs = new ReferralImpl();
            result.setReferral((Referral)refs);
            result.setResultCode(ResultCodeEnum.REFERRAL);
            result.setErrorMessage("Encountered referral attempting to handle compare request.");
            result.setMatchedDn((LdapDN)e.getResolvedName());
            do {
                refs.addLdapUrl((String)e.getReferralInfo());
            } while (e.skipReferral());
            session.write((Object)req.getResultResponse());
            return;
        }
        catch (Exception e) {
            NamingException ne;
            String msg = "failed to compare entry " + req.getName() + ": " + e.getMessage();
            if (IS_DEBUG) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
            }
            ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
            result.setResultCode(code);
            result.setErrorMessage(msg);
            if (e instanceof NamingException && (ne = (NamingException)e).getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn((LdapDN)ne.getResolvedName());
            }
            session.write((Object)req.getResultResponse());
            return;
        }
        result.setMatchedDn(req.getName());
        session.write((Object)req.getResultResponse());
    }

    public void init(StartupConfiguration cfg) {
    }
}

