/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.Control;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)BindHandler.class);
    private static final Control[] EMPTY = new Control[0];

    public void messageReceived(IoSession session, Object request) {
        LdapContext ctx;
        BindRequest req = (BindRequest)request;
        LdapResult result = req.getResultResponse().getLdapResult();
        Hashtable env = SessionRegistry.getSingleton().getEnvironment();
        if (!req.isSimple()) {
            result.setResultCode(ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
            result.setErrorMessage("Only simple binds currently supported");
            session.write((Object)req.getResultResponse());
            return;
        }
        boolean emptyDn = StringTools.isEmpty((String)req.getName());
        String dn = emptyDn ? "" : req.getName();
        byte[] creds = req.getCredentials();
        Hashtable cloned = (Hashtable)env.clone();
        cloned.put("java.naming.security.principal", dn);
        cloned.put("java.naming.security.credentials", creds);
        cloned.put("java.naming.security.authentication", "simple");
        if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            cloned.put("java.naming.referral", "ignore");
        } else {
            cloned.put("java.naming.referral", "throw");
        }
        try {
            if (cloned.containsKey("server.use.factory.instance")) {
                InitialContextFactory factory = (InitialContextFactory)cloned.get("server.use.factory.instance");
                if (factory == null) {
                    throw new NullPointerException("server.use.factory.instance was set in env but was null");
                }
                ctx = (LdapContext)factory.getInitialContext(cloned);
            } else {
                Control[] connCtls = req.getControls().values().toArray(EMPTY);
                ctx = new InitialLdapContext(cloned, (javax.naming.ldap.Control[])connCtls);
            }
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)e).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed";
            if (log.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + req.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NOSUCHOBJECT || code == ResultCodeEnum.ALIASPROBLEM || code == ResultCodeEnum.INVALIDDNSYNTAX || code == ResultCodeEnum.ALIASDEREFERENCINGPROBLEM)) {
                result.setMatchedDn(e.getResolvedName().toString());
            }
            result.setErrorMessage(msg);
            session.write((Object)req.getResultResponse());
            return;
        }
        SessionRegistry.getSingleton().setLdapContext(session, ctx);
        result.setResultCode(ResultCodeEnum.SUCCESS);
        session.write((Object)req.getResultResponse());
    }
}

