/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;

public class DnsMessage {
    private int transactionId;
    private MessageType messageType;
    private OpCode opCode;
    private boolean authoritativeAnswer;
    private boolean truncated;
    private boolean recursionDesired;
    private boolean recursionAvailable;
    private boolean reserved;
    private boolean acceptNonAuthenticatedData;
    private ResponseCode responseCode;
    private List<QuestionRecord> questionRecords;
    private List<ResourceRecord> answerRecords;
    private List<ResourceRecord> authorityRecords;
    private List<ResourceRecord> additionalRecords;

    public DnsMessage(int transactionId, MessageType messageType, OpCode opCode, boolean authoritativeAnswer, boolean truncated, boolean recursionDesired, boolean recursionAvailable, boolean reserved, boolean acceptNonAuthenticatedData, ResponseCode responseCode, List<QuestionRecord> question, List<ResourceRecord> answer, List<ResourceRecord> authority, List<ResourceRecord> additional) {
        this.transactionId = transactionId;
        this.messageType = messageType;
        this.opCode = opCode;
        this.authoritativeAnswer = authoritativeAnswer;
        this.truncated = truncated;
        this.recursionDesired = recursionDesired;
        this.recursionAvailable = recursionAvailable;
        this.reserved = reserved;
        this.acceptNonAuthenticatedData = acceptNonAuthenticatedData;
        this.responseCode = responseCode;
        this.questionRecords = question;
        this.answerRecords = answer;
        this.authorityRecords = authority;
        this.additionalRecords = additional;
    }

    public boolean isAcceptNonAuthenticatedData() {
        return this.acceptNonAuthenticatedData;
    }

    public List<ResourceRecord> getAdditionalRecords() {
        return this.additionalRecords;
    }

    public List<ResourceRecord> getAnswerRecords() {
        return this.answerRecords;
    }

    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    public List<ResourceRecord> getAuthorityRecords() {
        return this.authorityRecords;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public List<QuestionRecord> getQuestionRecords() {
        return this.questionRecords;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DnsMessage)) {
            return false;
        }
        DnsMessage rhs = (DnsMessage)object;
        return new EqualsBuilder().append(this.transactionId, rhs.transactionId).append(this.answerRecords, rhs.answerRecords).append((Object)this.opCode, (Object)rhs.opCode).append(this.recursionAvailable, rhs.recursionAvailable).append((Object)this.messageType, (Object)rhs.messageType).append(this.additionalRecords, rhs.additionalRecords).append(this.truncated, rhs.truncated).append(this.recursionDesired, rhs.recursionDesired).append((Object)this.responseCode, (Object)rhs.responseCode).append(this.authorityRecords, rhs.authorityRecords).append(this.authoritativeAnswer, rhs.authoritativeAnswer).append(this.reserved, rhs.reserved).append(this.acceptNonAuthenticatedData, rhs.acceptNonAuthenticatedData).append(this.questionRecords, rhs.questionRecords).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(-1805208585, -276770303).append(this.transactionId).append(this.answerRecords).append((Object)this.opCode).append(this.recursionAvailable).append((Object)this.messageType).append(this.additionalRecords).append(this.truncated).append(this.recursionDesired).append((Object)this.responseCode).append(this.authorityRecords).append(this.authoritativeAnswer).append(this.reserved).append(this.acceptNonAuthenticatedData).append(this.questionRecords).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("transactionId", this.transactionId).append("opCode", (Object)this.opCode).append("truncated", this.truncated).append("messageType", (Object)this.messageType).append("recursionDesired", this.recursionDesired).append("additionalRecords", this.additionalRecords).append("responseCode", (Object)this.responseCode).append("authorityRecords", this.authorityRecords).append("acceptNonAuthenticatedData", this.acceptNonAuthenticatedData).append("recursionAvailable", this.recursionAvailable).append("answerRecords", this.answerRecords).append("questionRecords", this.questionRecords).append("authoritativeAnswer", this.authoritativeAnswer).append("reserved", this.reserved).toString();
    }
}

