/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.dns.store.jndi.MultiBaseSearch;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.SingleBaseSearch;

public class JndiRecordStoreImpl
implements RecordStore {
    private final SearchStrategy strategy;

    public JndiRecordStoreImpl(String catalogBaseDn, String searchBaseDn, DirectoryService directoryService) {
        this.strategy = this.getSearchStrategy(catalogBaseDn, searchBaseDn, directoryService);
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        return this.strategy.getRecords(question);
    }

    private SearchStrategy getSearchStrategy(String catalogBaseDn, String searchBaseDn, DirectoryService directoryService) {
        if (catalogBaseDn != null) {
            return new MultiBaseSearch(catalogBaseDn, directoryService);
        }
        return new SingleBaseSearch(searchBaseDn, directoryService);
    }
}

