/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi.operations;

import java.util.HashSet;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResourceRecordModifier;
import org.apache.directory.server.dns.store.jndi.DnsOperation;

public class GetFlatRecord
implements DnsOperation {
    private final QuestionRecord question;

    public GetFlatRecord(QuestionRecord question) {
        this.question = question;
    }

    @Override
    public Set<ResourceRecord> execute(DirContext ctx, Name base) throws Exception {
        if (this.question == null) {
            return null;
        }
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("apacheDnsName", this.question.getDomainName()));
        matchAttrs.put(new BasicAttribute("apacheDnsType", this.question.getRecordType().name()));
        matchAttrs.put(new BasicAttribute("apacheDnsClass", this.question.getRecordClass().name()));
        HashSet<ResourceRecord> record = new HashSet<ResourceRecord>();
        NamingEnumeration<SearchResult> answer = ctx.search(base, (Attributes)matchAttrs);
        if (answer.hasMore()) {
            SearchResult result = answer.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) {
                return null;
            }
            record.add(this.getRecord(attrs));
        }
        return record;
    }

    private ResourceRecord getRecord(Attributes attrs) throws NamingException {
        ResourceRecordModifier modifier = new ResourceRecordModifier();
        Attribute attr = attrs.get("apacheDnsName");
        String dnsName = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsType");
        String dnsType = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsClass");
        String dnsClass = attr != null ? (String)attr.get() : null;
        attr = attrs.get("apacheDnsTtl");
        String dnsTtl = attr != null ? (String)attr.get() : null;
        modifier.setDnsName(dnsName);
        modifier.setDnsType(RecordType.valueOf(dnsType));
        modifier.setDnsClass(RecordClass.valueOf(dnsClass));
        modifier.setDnsTtl(Integer.parseInt(dnsTtl));
        NamingEnumeration<String> ids = attrs.getIDs();
        while (ids.hasMore()) {
            String id = ids.next();
            modifier.put(id, (String)attrs.get(id).get());
        }
        return modifier.getEntry();
    }
}

