/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import java.util.List;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(MonitorContext.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                DnsContext dnsContext = (DnsContext)session.getAttribute((Object)this.getContextKey());
                RecordStore store = dnsContext.getStore();
                List<ResourceRecord> records = dnsContext.getResourceRecords();
                StringBuffer sb = new StringBuffer();
                sb.append("Monitoring context:");
                sb.append("\n\tstore:                     " + store);
                sb.append("\n\trecords:                   " + records);
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in context monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

