/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.DnsCatalog;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBaseSearch
implements SearchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MultiBaseSearch.class);
    private final Catalog catalog;
    private final DirectoryService directoryService;

    MultiBaseSearch(String catalogBaseDn, DirectoryService directoryService) {
        this.directoryService = directoryService;
        try {
            LdapContext ctx = directoryService.getJndiContext(catalogBaseDn);
            this.catalog = new DnsCatalog((Map)new GetCatalog().execute((DirContext)ctx, null));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            String message = "Failed to get catalog context " + catalogBaseDn;
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        try {
            GetRecords getRecords = new GetRecords(question);
            String baseDn = this.catalog.getBaseDn(question.getDomainName());
            LdapContext dirContext = this.directoryService.getJndiContext(baseDn);
            return getRecords.execute(dirContext, null);
        }
        catch (LdapNameNotFoundException lnnfe) {
            LOG.debug("Name for DNS record search does not exist.", (Throwable)lnnfe);
            throw new DnsException(ResponseCode.NAME_ERROR);
        }
        catch (NamingException ne) {
            LOG.error(ne.getMessage(), (Throwable)ne);
            String message = "Failed to get initial context " + question.getDomainName();
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
        catch (Exception e) {
            LOG.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }
}

