/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.store.jndi;

import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.QuestionRecord;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.store.jndi.DnsOperation;
import org.apache.directory.server.dns.store.jndi.SearchStrategy;
import org.apache.directory.server.dns.store.jndi.operations.GetRecords;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleBaseSearch
implements SearchStrategy {
    private static final Logger log = LoggerFactory.getLogger(SingleBaseSearch.class);
    private DirContext ctx;
    private Hashtable<String, Object> env = new Hashtable();
    private InitialContextFactory factory;

    SingleBaseSearch(DnsConfiguration config, InitialContextFactory factory) {
        this.env.put("java.naming.factory.initial", config.getInitialContextFactory());
        this.env.put("java.naming.provider.url", config.getSearchBaseDn());
        this.env.put("java.naming.security.authentication", config.getSecurityAuthentication());
        this.env.put("java.naming.security.credentials", config.getSecurityCredentials());
        this.env.put("java.naming.security.principal", config.getSecurityPrincipal());
        this.factory = factory;
    }

    @Override
    public Set<ResourceRecord> getRecords(QuestionRecord question) throws DnsException {
        return this.execute(new GetRecords(question));
    }

    private Set<ResourceRecord> execute(DnsOperation operation) throws DnsException {
        try {
            if (this.ctx == null) {
                try {
                    this.ctx = (DirContext)this.factory.getInitialContext(this.env);
                }
                catch (LdapNameNotFoundException lnnfe) {
                    log.debug("Name for DNS record search does not exist.", (Throwable)lnnfe);
                    throw new DnsException(ResponseCode.NAME_ERROR);
                }
                catch (NamingException ne) {
                    log.error(ne.getMessage(), (Throwable)ne);
                    String message = "Failed to get initial context " + (String)this.env.get("java.naming.provider.url");
                    throw new ServiceConfigurationException(message, (Throwable)ne);
                }
            }
            return operation.execute(this.ctx, null);
        }
        catch (Exception e) {
            log.debug("Unexpected error retrieving DNS records.", (Throwable)e);
            throw new DnsException(ResponseCode.SERVER_FAILURE);
        }
    }
}

