/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import java.io.IOException;
import org.apache.directory.server.dns.io.encoder.RecordEncoder;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.mina.common.ByteBuffer;

public abstract class ResourceRecordEncoder
implements RecordEncoder {
    public void put(ByteBuffer byteBuffer, ResourceRecord record) throws IOException {
        this.putDomainName(byteBuffer, record.getDomainName());
        this.putRecordType(byteBuffer, record.getRecordType());
        this.putRecordClass(byteBuffer, record.getRecordClass());
        byteBuffer.putInt(record.getTimeToLive());
        this.putResourceRecord(byteBuffer, record);
    }

    protected abstract void putResourceRecordData(ByteBuffer var1, ResourceRecord var2);

    protected void putResourceRecord(ByteBuffer byteBuffer, ResourceRecord record) {
        int startPosition = byteBuffer.position();
        byteBuffer.position(startPosition + 2);
        this.putResourceRecordData(byteBuffer, record);
        this.putDataSize(byteBuffer, startPosition);
    }

    protected void putDataSize(ByteBuffer byteBuffer, int startPosition) {
        int endPosition = byteBuffer.position();
        short length = (short)(endPosition - startPosition - 2);
        byteBuffer.position(startPosition);
        byteBuffer.putShort(length);
        byteBuffer.position(endPosition);
    }

    protected void putDomainName(ByteBuffer byteBuffer, String domainName) {
        String[] labels = domainName.split("\\.");
        for (int ii = 0; ii < labels.length; ++ii) {
            byteBuffer.put((byte)labels[ii].length());
            char[] characters = labels[ii].toCharArray();
            for (int jj = 0; jj < characters.length; ++jj) {
                byteBuffer.put((byte)characters[jj]);
            }
        }
        byteBuffer.put((byte)0);
    }

    protected void putRecordType(ByteBuffer byteBuffer, RecordType recordType) {
        byteBuffer.putShort(recordType.convert().shortValue());
    }

    protected void putRecordClass(ByteBuffer byteBuffer, RecordClass recordClass) {
        byteBuffer.putShort(recordClass.convert().shortValue());
    }

    protected void putCharacterString(ByteBuffer byteBuffer, String characterString) {
        byteBuffer.put((byte)characterString.length());
        char[] characters = characterString.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            byteBuffer.put((byte)characters[ii]);
        }
    }
}

