/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsServer;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.dns.store.RecordStoreStub;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.DatagramAcceptor;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final int MAX_THREADS_DEFAULT = 4;
    protected static IoAcceptor udpAcceptor;
    protected static IoAcceptor tcpAcceptor;
    protected static ThreadPoolExecutor threadPoolExecutor;
    protected static ExecutorThreadModel threadModel;
    private static DnsServer udpDnsServer;
    private static DnsServer tcpDnsServer;

    public static void main(String[] args) throws Exception {
        int maxThreads = 4;
        threadPoolExecutor = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        threadModel.setExecutor((Executor)threadPoolExecutor);
        udpAcceptor = new DatagramAcceptor();
        tcpAcceptor = new SocketAcceptor();
        new Main().go();
    }

    public void go() {
        DnsConfiguration dnsConfiguration = new DnsConfiguration();
        dnsConfiguration.setEnabled(true);
        dnsConfiguration.setIpPort(10053);
        RecordStoreStub store = new RecordStoreStub();
        this.startup(dnsConfiguration, store);
    }

    private void startup(DnsConfiguration dnsConfig, RecordStore store) {
        if (!dnsConfig.isEnabled()) {
            return;
        }
        try {
            DatagramAcceptorConfig serviceConfig = new DatagramAcceptorConfig();
            serviceConfig.setThreadModel((ThreadModel)threadModel);
            udpDnsServer = new DnsServer(dnsConfig, udpAcceptor, (IoServiceConfig)serviceConfig, store);
            tcpDnsServer = new DnsServer(dnsConfig, tcpAcceptor, (IoServiceConfig)serviceConfig, store);
        }
        catch (Throwable t) {
            log.error("Failed to start the DNS service", t);
        }
    }

    protected void shutdown() {
        if (udpDnsServer != null) {
            udpDnsServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of DNS Service complete: " + udpDnsServer);
            }
            udpDnsServer = null;
        }
        if (tcpDnsServer != null) {
            tcpDnsServer.destroy();
            if (log.isInfoEnabled()) {
                log.info("Unbind of DNS Service complete: " + tcpDnsServer);
            }
            tcpDnsServer = null;
        }
    }

    static {
        threadModel = ExecutorThreadModel.getInstance((String)"ApacheDS");
    }
}

