/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnsServer {
    private static final Logger log = LoggerFactory.getLogger(DnsServer.class);
    private DnsConfiguration config;
    private IoAcceptor acceptor;
    private RecordStore store;
    private IoHandler handler;

    public DnsServer(DnsConfiguration config, IoAcceptor acceptor, IoServiceConfig serviceConfig, RecordStore store) {
        this.config = config;
        this.acceptor = acceptor;
        this.store = store;
        String name = config.getServiceName();
        int port = config.getIpPort();
        try {
            this.handler = new DnsProtocolHandler(config, this.store);
            acceptor.bind((SocketAddress)new InetSocketAddress(port), this.handler, serviceConfig);
            log.debug("{} listening on port {}.", (Object)name, (Object)new Integer(port));
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isDifferent(Dictionary<String, Object> newConfig) {
        return this.config.isDifferent(newConfig);
    }

    public void destroy() {
        this.acceptor.unbind((SocketAddress)new InetSocketAddress(this.config.getIpPort()));
        this.acceptor = null;
        this.handler = null;
        log.debug("{} has stopped listening on port {}.", (Object)this.config.getServiceName(), (Object)new Integer(this.config.getIpPort()));
    }
}

