/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import java.util.ArrayList;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.protocol.DnsProtocolCodecFactory;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.service.DomainNameServiceChain;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger(DnsProtocolHandler.class);
    private DnsConfiguration config;
    private RecordStore store;
    private IoHandlerCommand dnsService;
    private String contextKey = "context";

    public DnsProtocolHandler(DnsConfiguration config, RecordStore store) {
        this.config = config;
        this.store = store;
        this.dnsService = new DomainNameServiceChain();
    }

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("{} CREATED", (Object)session.getRemoteAddress());
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)DnsProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        log.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        log.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.debug("{} IDLE({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        log.debug("{} RCVD: {}", (Object)session.getRemoteAddress(), message);
        try {
            DnsContext dnsContext = new DnsContext();
            dnsContext.setConfig(this.config);
            dnsContext.setStore(this.store);
            session.setAttribute(this.getContextKey(), (Object)dnsContext);
            this.dnsService.execute(null, session, message);
            DnsMessage response = dnsContext.getReply();
            session.write((Object)response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            DnsMessage request = (DnsMessage)message;
            DnsException de = (DnsException)e;
            DnsMessageModifier modifier = new DnsMessageModifier();
            modifier.setTransactionId(request.getTransactionId());
            modifier.setMessageType(MessageType.RESPONSE);
            modifier.setOpCode(OpCode.QUERY);
            modifier.setAuthoritativeAnswer(false);
            modifier.setTruncated(false);
            modifier.setRecursionDesired(request.isRecursionDesired());
            modifier.setRecursionAvailable(false);
            modifier.setReserved(false);
            modifier.setAcceptNonAuthenticatedData(false);
            modifier.setResponseCode(ResponseCode.convert((byte)de.getResponseCode()));
            modifier.setQuestionRecords(request.getQuestionRecords());
            modifier.setAnswerRecords(new ArrayList<ResourceRecord>());
            modifier.setAuthorityRecords(new ArrayList<ResourceRecord>());
            modifier.setAdditionalRecords(new ArrayList<ResourceRecord>());
            session.write((Object)modifier.getDnsMessage());
        }
    }

    public void messageSent(IoSession session, Object message) {
        log.debug("{} SENT: {}", (Object)session.getRemoteAddress(), message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

