/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class OpCode
implements Comparable {
    public static final OpCode QUERY = new OpCode(0, "Standard query");
    public static final OpCode IQUERY = new OpCode(1, "Inverse query");
    public static final OpCode STATUS = new OpCode(2, "Server status request");
    public static final OpCode NOTIFY = new OpCode(4, "Zone transfer notification");
    public static final OpCode UPDATE = new OpCode(5, "Dynamic update message");
    private static final OpCode[] values = new OpCode[]{QUERY, IQUERY, STATUS, NOTIFY, UPDATE};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private OpCode(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((OpCode)that).ordinal;
    }

    public static OpCode getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (OpCode.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return QUERY;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

