/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.service;

import org.apache.directory.server.dns.DnsException;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.messages.DnsMessageModifier;
import org.apache.directory.server.dns.messages.MessageType;
import org.apache.directory.server.dns.messages.OpCode;
import org.apache.directory.server.dns.messages.ResourceRecords;
import org.apache.directory.server.dns.messages.ResponseCode;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.directory.server.protocol.shared.chain.Filter;
import org.apache.directory.server.protocol.shared.chain.impl.CommandBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsExceptionHandler
extends CommandBase
implements Filter {
    private static final Logger log = LoggerFactory.getLogger((Class)DnsExceptionHandler.class);

    public boolean execute(Context context) throws Exception {
        return false;
    }

    public boolean postprocess(Context context, Exception exception) {
        if (exception == null) {
            return false;
        }
        DnsContext dnsContext = (DnsContext)context;
        DnsException de = (DnsException)exception;
        DnsMessage message = dnsContext.getRequest();
        if (log.isDebugEnabled()) {
            log.debug(de.getMessage(), (Throwable)de);
        } else {
            log.info(de.getMessage());
        }
        DnsMessageModifier modifier = new DnsMessageModifier();
        modifier.setTransactionId(message.getTransactionId());
        modifier.setMessageType(MessageType.RESPONSE);
        modifier.setOpCode(OpCode.QUERY);
        modifier.setAuthoritativeAnswer(false);
        modifier.setTruncated(false);
        modifier.setRecursionDesired(message.isRecursionDesired());
        modifier.setRecursionAvailable(false);
        modifier.setReserved(false);
        modifier.setAcceptNonAuthenticatedData(false);
        modifier.setResponseCode(ResponseCode.getTypeByOrdinal(de.getResponseCode()));
        modifier.setQuestionRecords(message.getQuestionRecords());
        modifier.setAnswerRecords(new ResourceRecords());
        modifier.setAuthorityRecords(new ResourceRecords());
        modifier.setAdditionalRecords(new ResourceRecords());
        dnsContext.setReply(modifier.getDnsMessage());
        return true;
    }
}

