/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.protocol.DnsProtocolHandler;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsServer {
    private static final Logger log = LoggerFactory.getLogger((Class)DnsServer.class);
    private DnsConfiguration config;
    private IoAcceptor acceptor;
    private RecordStore store;
    private IoHandler handler;

    public DnsServer(DnsConfiguration config, IoAcceptor acceptor, RecordStore store) {
        this.config = config;
        this.acceptor = acceptor;
        this.store = store;
        String name = config.getName();
        int port = config.getPort();
        try {
            this.handler = new DnsProtocolHandler(config, this.store);
            acceptor.bind((SocketAddress)new InetSocketAddress(port), this.handler);
            log.debug("{} listening on port {}", (Object)name, (Object)new Integer(port));
        }
        catch (IOException ioe) {
            log.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public boolean isDifferent(Dictionary newConfig) {
        return this.config.isDifferent(newConfig);
    }

    public void destroy() {
        this.acceptor.unbind((SocketAddress)new InetSocketAddress(this.config.getPort()));
        this.acceptor = null;
        this.handler = null;
        log.debug("{} has stopped listening on port {}", (Object)this.config.getName(), (Object)new Integer(this.config.getPort()));
    }
}

