/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RecordClass
implements Comparable {
    public static final RecordClass IN = new RecordClass(1, "IN", "Internet");
    public static final RecordClass CS = new RecordClass(2, "CS", "CSNET class");
    public static final RecordClass CH = new RecordClass(3, "CH", "CHAOS class");
    public static final RecordClass HS = new RecordClass(4, "HS", "Hesiod [Dyer 87]");
    public static final RecordClass NONE = new RecordClass(254, "NONE", "Special value used in dynamic update messages");
    public static final RecordClass ANY = new RecordClass(255, "*", "Any class");
    private static final RecordClass[] values = new RecordClass[]{IN, CS, CH, HS, NONE, ANY};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final String code;
    private final int ordinal;

    private RecordClass(int ordinal, String code, String name) {
        this.ordinal = ordinal;
        this.code = code;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object that) {
        return this.ordinal - ((RecordClass)that).ordinal;
    }

    public static RecordClass getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (RecordClass.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return IN;
    }

    public static RecordClass getTypeByName(String type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (!RecordClass.values[ii].code.equalsIgnoreCase(type)) continue;
            return values[ii];
        }
        return IN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getCode() {
        return this.code;
    }
}

