/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.protocol;

import org.apache.directory.server.dns.DnsConfiguration;
import org.apache.directory.server.dns.messages.DnsMessage;
import org.apache.directory.server.dns.protocol.DnsProtocolCodecFactory;
import org.apache.directory.server.dns.service.DnsContext;
import org.apache.directory.server.dns.service.DomainNameServiceChain;
import org.apache.directory.server.dns.store.RecordStore;
import org.apache.directory.server.protocol.shared.chain.Command;
import org.apache.directory.server.protocol.shared.chain.Context;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsProtocolHandler
implements IoHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)DnsProtocolHandler.class);
    private DnsConfiguration config;
    private RecordStore store;
    private Command dnsService;

    public DnsProtocolHandler(DnsConfiguration config, RecordStore store) {
        this.config = config;
        this.store = store;
        this.dnsService = new DomainNameServiceChain();
    }

    public void sessionCreated(IoSession session) throws Exception {
        log.debug("{} CREATED", (Object)session.getRemoteAddress());
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)DnsProtocolCodecFactory.getInstance()));
    }

    public void sessionOpened(IoSession session) {
        log.debug("{} OPENED", (Object)session.getRemoteAddress());
    }

    public void sessionClosed(IoSession session) {
        log.debug("{} CLOSED", (Object)session.getRemoteAddress());
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        log.debug("{} IDLE({})", (Object)session.getRemoteAddress(), (Object)status);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        log.error(session.getRemoteAddress() + " EXCEPTION", cause);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) {
        log.debug("{} RCVD: {}", (Object)session.getRemoteAddress(), message);
        DnsMessage request = (DnsMessage)message;
        try {
            DnsContext dnsContext = new DnsContext();
            dnsContext.setConfig(this.config);
            dnsContext.setStore(this.store);
            dnsContext.setRequest(request);
            this.dnsService.execute((Context)dnsContext);
            session.write((Object)dnsContext.getReply());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void messageSent(IoSession session, Object message) {
        log.debug("{} SENT: {}", (Object)session.getRemoteAddress(), message);
    }
}

