/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.io.encoder;

import java.io.IOException;
import org.apache.directory.server.dns.io.encoder.RecordEncoder;
import org.apache.directory.server.dns.messages.RecordClass;
import org.apache.directory.server.dns.messages.RecordType;
import org.apache.directory.server.dns.messages.ResourceRecord;
import org.apache.mina.common.ByteBuffer;

public abstract class ResourceRecordEncoder
implements RecordEncoder {
    protected abstract byte[] encodeResourceData(ResourceRecord var1);

    public void encode(ByteBuffer out, ResourceRecord record) throws IOException {
        this.encodeDomainName(out, record.getDomainName());
        this.encodeRecordType(out, record.getRecordType());
        this.encodeRecordClass(out, record.getRecordClass());
        out.putInt(record.getTimeToLive());
        byte[] resourceData = this.encodeResourceData(record);
        out.putShort((short)resourceData.length);
        out.put(resourceData);
    }

    protected byte[] encodeDomainName(String domainName) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)256);
        this.encodeDomainName(byteBuffer, domainName);
        byteBuffer.flip();
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    protected void encodeDomainName(ByteBuffer byteBuffer, String domainName) {
        String[] labels = domainName.split("\\.");
        for (int ii = 0; ii < labels.length; ++ii) {
            byteBuffer.put((byte)labels[ii].length());
            char[] characters = labels[ii].toCharArray();
            for (int jj = 0; jj < characters.length; ++jj) {
                byteBuffer.put((byte)characters[jj]);
            }
        }
        byteBuffer.put((byte)0);
    }

    protected void encodeRecordType(ByteBuffer byteBuffer, RecordType recordType) {
        byteBuffer.putShort((short)recordType.getOrdinal());
    }

    protected void encodeRecordClass(ByteBuffer byteBuffer, RecordClass recordClass) {
        byteBuffer.putShort((short)recordClass.getOrdinal());
    }

    protected byte[] encodeCharacterString(String characterString) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)256);
        byteBuffer.put((byte)characterString.length());
        char[] characters = characterString.toCharArray();
        for (int ii = 0; ii < characters.length; ++ii) {
            byteBuffer.put((byte)characters[ii]);
        }
        byteBuffer.flip();
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    protected void putUnsignedByte(ByteBuffer byteBuffer, int value) {
        byteBuffer.put((byte)(value & 0xFF));
    }

    protected void putUnsignedByte(ByteBuffer byteBuffer, int position, int value) {
        byteBuffer.put(position, (byte)(value & 0xFF));
    }

    protected void putUnsignedShort(ByteBuffer byteBuffer, int value) {
        byteBuffer.putShort((short)(value & 0xFFFF));
    }

    protected void putUnsignedShort(ByteBuffer byteBuffer, int position, int value) {
        byteBuffer.putShort(position, (short)(value & 0xFFFF));
    }

    protected void putUnsignedInt(ByteBuffer byteBuffer, long value) {
        byteBuffer.putInt((int)(value & 0xFFFFFFFFL));
    }

    protected void putUnsignedInt(ByteBuffer byteBuffer, int position, long value) {
        byteBuffer.putInt(position, (int)(value & 0xFFFFFFFFL));
    }
}

