/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.messages;

public enum MessageType {
    DHCPUNRECOGNIZED(-1, "unrecognized"),
    DHCPDISCOVER(1, "DHCP Discover"),
    DHCPOFFER(2, "DHCP Offer"),
    DHCPREQUEST(3, "DHCP Request"),
    DHCPDECLINE(4, "DHCP Decline"),
    DHCPACK(5, "DHCP Acknowledge"),
    DHCPNAK(6, "DHCP Not Acknowledge"),
    DHCPRELEASE(7, "DHCP Release"),
    DHCPINFORM(8, "DHCP Inform");

    private String name;
    private byte ordinal;

    public static MessageType getTypeByCode(byte type) {
        for (MessageType mt : MessageType.values()) {
            if (type != mt.getCode()) continue;
            return mt;
        }
        return DHCPUNRECOGNIZED;
    }

    public byte getCode() {
        return this.ordinal;
    }

    private MessageType(byte ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

