/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.protocol;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.protocol.DhcpProtocolCodecFactory;
import org.apache.directory.server.dhcp.service.DhcpServiceImpl;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.DatagramConnector;

public class DhcpProtocolHandler
implements IoHandler {
    public void sessionCreated(IoSession session) throws Exception {
        System.out.println(session.getRemoteAddress() + " CREATED");
        session.getFilterChain().addFirst("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new DhcpProtocolCodecFactory()));
    }

    public void sessionOpened(IoSession session) {
        System.out.println(session.getRemoteAddress() + " OPENED");
    }

    public void sessionClosed(IoSession session) {
        System.out.println(session.getRemoteAddress() + " CLOSED");
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        System.out.println(session.getRemoteAddress() + " IDLE(" + status + ")");
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        System.out.println(session.getRemoteAddress() + " EXCEPTION");
        cause.printStackTrace(System.out);
        session.close();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        System.out.println(session.getRemoteAddress() + " RCVD: " + message);
        DhcpMessage request = (DhcpMessage)message;
        if (request.getOpCode() == 1) {
            DhcpServiceImpl dhcpService = new DhcpServiceImpl();
            DhcpMessage reply = dhcpService.getReplyFor(request);
            int PORT = 68;
            DatagramConnector connector = new DatagramConnector();
            InetAddress broadcast = InetAddress.getByName(null);
            ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(broadcast, PORT), (IoHandler)new DhcpProtocolHandler());
            future.join();
            IoSession replySession = future.getSession();
            replySession.write((Object)reply).join();
            replySession.close();
        }
    }

    public void messageSent(IoSession session, Object message) {
        System.out.println(session.getRemoteAddress() + " SENT: " + message);
    }
}

