/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dhcp.messages;

import org.apache.directory.server.dhcp.messages.MessageType;
import org.apache.directory.server.dhcp.options.OptionsField;

public class DhcpMessage {
    private MessageType messageType;
    private byte opCode;
    private byte hardwareAddressType;
    private byte hardwareAddressLength;
    private byte hardwareOptions;
    private int transactionId;
    private short seconds;
    private short flags;
    private byte[] actualClientAddress = new byte[4];
    private byte[] assignedClientAddress = new byte[4];
    private byte[] nextServerAddress = new byte[4];
    private byte[] relayAgentAddress = new byte[4];
    private byte[] clientHardwareAddress = new byte[16];
    private byte[] serverHostname = new byte[64];
    private byte[] bootFileName = new byte[128];
    private OptionsField options = new OptionsField();

    public DhcpMessage(MessageType messageType, byte opCode, byte hardwareAddressType, byte hardwareAddressLength, byte hardwareOptions, int transactionId, short seconds, short flags, byte[] actualClientAddress, byte[] assignedClientAddress, byte[] nextServerAddress, byte[] relayAgentAddress, byte[] clientHardwareAddress, byte[] serverHostname, byte[] bootFileName, OptionsField options) {
        this.messageType = messageType;
        this.opCode = opCode;
        this.hardwareAddressType = hardwareAddressType;
        this.hardwareAddressLength = hardwareAddressLength;
        this.hardwareOptions = hardwareOptions;
        this.transactionId = transactionId;
        this.seconds = seconds;
        this.flags = flags;
        this.actualClientAddress = actualClientAddress;
        this.assignedClientAddress = assignedClientAddress;
        this.nextServerAddress = nextServerAddress;
        this.relayAgentAddress = relayAgentAddress;
        this.clientHardwareAddress = clientHardwareAddress;
        this.serverHostname = serverHostname;
        this.bootFileName = bootFileName;
        this.options = options;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public byte getHardwareAddressType() {
        return this.hardwareAddressType;
    }

    public byte getHardwareAddressLength() {
        return this.hardwareAddressLength;
    }

    public byte getHardwareOptions() {
        return this.hardwareOptions;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public short getSeconds() {
        return this.seconds;
    }

    public short getFlags() {
        return this.flags;
    }

    public byte[] getActualClientAddress() {
        return this.actualClientAddress;
    }

    public byte[] getAssignedClientAddress() {
        return this.assignedClientAddress;
    }

    public byte[] getNextServerAddress() {
        return this.nextServerAddress;
    }

    public byte[] getRelayAgentAddress() {
        return this.relayAgentAddress;
    }

    public byte[] getClientHardwareAddress() {
        return this.clientHardwareAddress;
    }

    public byte[] getServerHostname() {
        return this.serverHostname;
    }

    public byte[] getBootFileName() {
        return this.bootFileName;
    }

    public OptionsField getOptions() {
        return this.options;
    }
}

