/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotParentIdAndRdnSerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotRdnIndex
extends MavibotIndex<ParentIdAndRdn> {
    private static final Logger LOG = LoggerFactory.getLogger(MavibotRdnIndex.class);

    public MavibotRdnIndex() {
        super("1.3.6.1.4.1.18060.0.4.1.2.50", true);
        this.initialized = false;
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            throw e;
        }
        String path = new File(this.wkDirPath, attributeType.getOid()).getAbsolutePath();
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        FileWriter fw = new FileWriter(new File(path + "-" + attributeType.getName() + ".txt"));
        fw.write(attributeType.toString());
        fw.close();
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        MavibotParentIdAndRdnSerializer.setSchemaManager(schemaManager);
        MavibotParentIdAndRdnSerializer parentIdAndSerializer = new MavibotParentIdAndRdnSerializer();
        String forwardTableName = this.attributeType.getOid() + "_forward";
        this.forward = new MavibotTable(this.recordMan, schemaManager, forwardTableName, parentIdAndSerializer, new StringSerializer(), false);
        String reverseTableName = this.attributeType.getOid() + "_reverse";
        this.reverse = new MavibotTable(this.recordMan, schemaManager, reverseTableName, new StringSerializer(), parentIdAndSerializer, false);
    }
}

