/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotTable;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MavibotCursor<K, V>
extends AbstractCursor<org.apache.directory.api.ldap.model.cursor.Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)"CURSOR");
    private final MavibotTable<K, V> table;
    private org.apache.directory.api.ldap.model.cursor.Tuple<K, V> returnedTuple = new org.apache.directory.api.ldap.model.cursor.Tuple();
    private boolean valueAvailable = false;
    private TupleCursor<K, V> browser;

    public MavibotCursor(MavibotTable<K, V> table) {
        LOG_CURSOR.debug("Creating MavibotCursor {}", (Object)this);
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws LdapException, CursorException {
        this.checkNotClosed("beforeKey()");
        this.closeBrowser(this.browser);
        try {
            this.browser = this.table.getBTree().browseFrom(key);
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
        this.clearValue();
    }

    public void afterKey(K key) throws LdapException, CursorException {
        this.checkNotClosed("afterKey()");
        this.closeBrowser(this.browser);
        try {
            this.browser = this.table.getBTree().browseFrom(key);
            if (this.table.isDupsEnabled()) {
                this.browser.nextKey();
            } else if (this.browser.hasNextKey()) {
                this.browser.nextKey();
            } else {
                this.browser.afterLast();
            }
            this.clearValue();
        }
        catch (IOException e) {
            this.clearValue();
            throw new CursorException((Throwable)e);
        }
    }

    public void beforeValue(K key, V value) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_596, (Object[])new Object[0]));
    }

    public void afterValue(K key, V value) throws LdapException, CursorException {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_596, (Object[])new Object[0]));
    }

    public void before(org.apache.directory.api.ldap.model.cursor.Tuple<K, V> element) throws LdapException, CursorException {
        this.beforeKey(element.getKey());
    }

    public void after(org.apache.directory.api.ldap.model.cursor.Tuple<K, V> element) throws LdapException, CursorException {
        this.afterKey(element.getKey());
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        try {
            if (this.browser == null) {
                this.browser = this.table.getBTree().browse();
            }
            this.browser.beforeFirst();
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        try {
            if (this.browser == null) {
                this.browser = this.table.getBTree().browse();
            }
            this.browser.afterLast();
            this.clearValue();
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.afterLast();
        }
        try {
            if (this.browser.hasPrev()) {
                Tuple tuple = this.browser.prev();
                this.returnedTuple.setKey(tuple.getKey());
                this.returnedTuple.setValue(tuple.getValue());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.beforeFirst();
        }
        try {
            if (this.browser.hasNext()) {
                Tuple tuple = this.browser.next();
                this.returnedTuple.setKey(tuple.getKey());
                this.returnedTuple.setValue(tuple.getValue());
                this.valueAvailable = true;
                return true;
            }
            this.clearValue();
            return false;
        }
        catch (IOException e) {
            throw new CursorException((Throwable)e);
        }
    }

    public org.apache.directory.api.ldap.model.cursor.Tuple<K, V> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public void close() {
        LOG_CURSOR.debug("Closing MavibotCursor {}", (Object)this);
        super.close();
        this.closeBrowser(this.browser);
    }

    public void close(Exception cause) {
        LOG_CURSOR.debug("Closing MavibotCursor {}", (Object)this);
        super.close(cause);
        this.closeBrowser(this.browser);
    }

    private void closeBrowser(TupleCursor<K, V> browser) {
        if (browser != null) {
            browser.close();
        }
    }
}

