/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.naming.InvalidNameException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.partition.impl.avl.AvlPartition;
import org.apache.directory.server.core.partition.ldif.AbstractLdifPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.impl.avl.AvlStore;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFileLdifPartition
extends AbstractLdifPartition {
    private RandomAccessFile ldifFile;
    private volatile boolean enableRewriting = true;
    private boolean dirty = false;
    private Object lock = new Object();
    private static Logger LOG = LoggerFactory.getLogger(SingleFileLdifPartition.class);

    public SingleFileLdifPartition() {
        this.wrappedPartition = new AvlPartition();
    }

    protected void doInit() throws InvalidNameException, Exception {
        if (this.getPartitionPath() == null) {
            throw new IllegalArgumentException("Partition path cannot be null");
        }
        File partitionFile = new File(this.getPartitionPath());
        if (partitionFile.exists() && !partitionFile.isFile()) {
            throw new IllegalArgumentException("Partition path must be a LDIF file");
        }
        this.ldifFile = new RandomAccessFile(partitionFile, "rws");
        this.wrappedPartition.setId(this.id);
        this.wrappedPartition.setSuffix(this.suffix);
        this.wrappedPartition.setSchemaManager(this.schemaManager);
        this.wrappedPartition.initialize();
        this.searchEngine = this.wrappedPartition.getSearchEngine();
        LOG.debug("id is : {}", (Object)this.wrappedPartition.getId());
        if (this.suffix == null || this.suffix.isEmpty()) {
            String msg = I18n.err((I18n)I18n.ERR_150, (Object[])new Object[0]);
            LOG.error(msg);
            throw new LdapInvalidDnException(msg);
        }
        if (!this.suffix.isSchemaAware()) {
            this.suffix.apply(this.schemaManager);
        }
        this.loadEntries();
    }

    private void loadEntries() throws Exception {
        RandomAccessLdifReader parser = new RandomAccessLdifReader();
        Iterator itr = parser.iterator();
        if (!itr.hasNext()) {
            return;
        }
        LdifEntry ldifEntry = (LdifEntry)itr.next();
        this.contextEntry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
        AvlStore store = this.wrappedPartition.getStore();
        if (this.suffix.equals((Object)this.contextEntry.getDn())) {
            this.addMandatoryOpAt(this.contextEntry);
            store.add(this.contextEntry);
        } else {
            throw new LdapException("The given LDIF file doesn't contain the context entry");
        }
        while (itr.hasNext()) {
            ldifEntry = (LdifEntry)itr.next();
            DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
            this.addMandatoryOpAt((Entry)entry);
            store.add((Entry)entry);
        }
        parser.close();
    }

    public void bind(BindOperationContext bindContext) throws LdapException {
        this.wrappedPartition.bind(bindContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext addContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            this.wrappedPartition.add(addContext);
            if (this.contextEntry == null && (entry = addContext.getEntry()).getDn().equals((Object)this.suffix)) {
                this.contextEntry = entry;
            }
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedPartition.modify(modifyContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext renameContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedPartition.rename(renameContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoveOperationContext moveContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedPartition.move(moveContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext opContext) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedPartition.moveAndRename(opContext);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Long id) throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            this.wrappedPartition.delete((Comparable)id);
            this.dirty = true;
            this.rewritePartitionData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePartitionData() throws LdapException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.enableRewriting || !this.dirty) {
                return;
            }
            try {
                this.ldifFile.setLength(0L);
                Long suffixId = (Long)this.wrappedPartition.getEntryId(this.suffix);
                if (suffixId == null) {
                    this.contextEntry = null;
                    return;
                }
                IndexCursor cursor = this.wrappedPartition.getOneLevelIndex().forwardCursor((Object)suffixId);
                this.appendLdif((Entry)this.wrappedPartition.lookup((Comparable)suffixId));
                while (cursor.next()) {
                    Long childId = (Long)((IndexEntry)cursor.get()).getId();
                    ClonedServerEntry entry = this.wrappedPartition.lookup((Comparable)childId);
                    this.appendLdif((Entry)entry);
                    this.appendRecursive(childId, null);
                }
                cursor.close();
                this.dirty = false;
            }
            catch (LdapException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRecursive(Long entryId, Map<Long, IndexCursor<Long, Entry, Long>> cursorMap) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            IndexCursor cursor = null;
            if (cursorMap == null) {
                cursorMap = new HashMap<Long, IndexCursor<Long, Entry, Long>>();
            }
            if ((cursor = cursorMap.get(entryId)) == null) {
                cursor = this.wrappedPartition.getOneLevelIndex().forwardCursor((Object)entryId);
                cursor.beforeFirst();
                cursorMap.put(entryId, (IndexCursor<Long, Entry, Long>)cursor);
            }
            if (!cursor.next()) {
                cursorMap.remove(entryId);
                cursor.close();
            } else {
                do {
                    IndexEntry idxEntry = (IndexEntry)cursor.get();
                    ClonedServerEntry entry = this.wrappedPartition.lookup((Comparable)idxEntry.getId());
                    Long childId = (Long)this.wrappedPartition.getEntryId(entry.getDn());
                    this.appendLdif((Entry)entry);
                    this.appendRecursive(childId, cursorMap);
                } while (cursor.next());
                cursorMap.remove(entryId);
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLdif(Entry entry) throws IOException, LdapException {
        Object object = this.lock;
        synchronized (object) {
            String ldif = LdifUtils.convertToLdif((Entry)entry);
            this.ldifFile.write(Strings.getBytesUtf8((String)(ldif + "\n")));
        }
    }

    private void addMandatoryOpAt(Entry entry) throws LdapException {
        if (entry.get("entryCSN") == null) {
            entry.add("entryCSN", new String[]{defaultCSNFactory.newInstance().toString()});
        }
        if (entry.get("entryUUID") == null) {
            String uuid = UUID.randomUUID().toString();
            entry.add("entryUUID", new String[]{uuid});
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        this.ldifFile.close();
    }

    public void setEnableRewriting(boolean enableRewriting) throws LdapException {
        this.enableRewriting = enableRewriting;
        this.rewritePartitionData();
    }

    private class RandomAccessLdifReader
    extends LdifReader {
        private long len;

        public RandomAccessLdifReader() throws LdapException {
            try {
                this.len = SingleFileLdifPartition.this.ldifFile.length();
            }
            catch (IOException e) {
                LdapException le = new LdapException(e.getMessage(), (Throwable)e);
                le.initCause((Throwable)e);
                throw le;
            }
        }

        protected String getLine() throws IOException {
            if (this.len == 0L) {
                return null;
            }
            return SingleFileLdifPartition.this.ldifFile.readLine();
        }
    }
}

