/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import javax.naming.directory.InvalidAttributeValueException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.kerberos.shared.store.operations.StoreUtils;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.name.DN;

public class GetPrincipal
implements DirectoryServiceOperation {
    private static final long serialVersionUID = 4598007518413451945L;
    private final KerberosPrincipal principal;

    public GetPrincipal(KerberosPrincipal principal) {
        this.principal = principal;
    }

    public Object execute(CoreSession session, DN base) throws Exception {
        if (this.principal == null) {
            return null;
        }
        return this.getEntry(StoreUtils.findPrincipalEntry(session, base, this.principal.getName()));
    }

    private PrincipalStoreEntry getEntry(ServerEntry entry) throws Exception {
        String val;
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        modifier.setDistinguishedName(entry.getDn().getName());
        String principal = entry.get("krb5PrincipalName").getString();
        modifier.setPrincipal(new KerberosPrincipal(principal));
        String keyVersionNumber = entry.get("krb5KeyVersionNumber").getString();
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        if (entry.get("krb5AccountDisabled") != null) {
            val = entry.get("krb5AccountDisabled").getString();
            modifier.setDisabled("true".equalsIgnoreCase(val));
        }
        if (entry.get("krb5AccountLockedOut") != null) {
            val = entry.get("krb5AccountLockedOut").getString();
            modifier.setLockedOut("true".equalsIgnoreCase(val));
        }
        if (entry.get("krb5AccountExpirationTime") != null) {
            val = entry.get("krb5AccountExpirationTime").getString();
            try {
                modifier.setExpiration(KerberosTime.getTime(val));
            }
            catch (ParseException e) {
                throw new InvalidAttributeValueException("Account expiration attribute krb5AccountExpirationTime contained an invalid value for generalizedTime: " + val);
            }
        }
        if (entry.get("apacheSamType") != null) {
            String samType = entry.get("apacheSamType").getString();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        if (entry.get("krb5Key") != null) {
            EntryAttribute krb5key = entry.get("krb5Key");
            try {
                Map<EncryptionType, EncryptionKey> keyMap = modifier.reconstituteKeyMap(krb5key);
                modifier.setKeyMap(keyMap);
            }
            catch (IOException ioe) {
                throw new InvalidAttributeValueException(I18n.err((String)I18n.ERR_623, (Object[])new Object[]{"krb5Key"}));
            }
        }
        return modifier.getEntry();
    }
}

