/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.ArrayList;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.kerberos.shared.store.operations.StoreUtils;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.shared.ldap.entry.DefaultServerAttribute;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.ServerModification;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.StringTools;

public class ChangePassword
implements DirectoryServiceOperation {
    private static final long serialVersionUID = -7147685183641418353L;
    protected KerberosPrincipal principal;
    protected String newPassword;

    public ChangePassword(KerberosPrincipal principal, String newPassword) {
        this.principal = principal;
        this.newPassword = newPassword;
    }

    public Object execute(CoreSession session, DN searchBaseDn) throws Exception {
        if (this.principal == null) {
            return null;
        }
        SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
        ArrayList<ServerModification> mods = new ArrayList<ServerModification>(2);
        DefaultServerAttribute newPasswordAttribute = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("userPassword"), (byte[][])new byte[][]{StringTools.getBytesUtf8((String)this.newPassword)});
        mods.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)newPasswordAttribute));
        DefaultServerAttribute principalAttribute = new DefaultServerAttribute(schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName"), new String[]{this.principal.getName()});
        mods.add(new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)principalAttribute));
        ServerEntry entry = StoreUtils.findPrincipalEntry(session, searchBaseDn, this.principal.getName());
        session.modify(entry.getDn(), mods);
        return entry.getDn().toString();
    }
}

