/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.Decoder;
import org.apache.directory.server.kerberos.shared.io.decoder.DecoderFactory;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStamp;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedTimeStampModifier;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptedTimestampDecoder
implements Decoder,
DecoderFactory {
    public Decoder getDecoder() {
        return new EncryptedTimestampDecoder();
    }

    public Encodable decode(byte[] encodedEncryptedTimestamp) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(encodedEncryptedTimestamp);
        DERSequence sequence = (DERSequence)ais.readObject();
        return this.decodeEncryptedTimestamp(sequence);
    }

    protected EncryptedTimeStamp decodeEncryptedTimestamp(DERSequence sequence) {
        EncryptedTimeStampModifier modifier = new EncryptedTimeStampModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERGeneralizedTime tag0 = (DERGeneralizedTime)derObject;
                    modifier.setKerberosTime(KerberosTimeDecoder.decode(tag0));
                    break;
                }
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    modifier.setMicroSecond(tag1.intValue());
                }
            }
        }
        return modifier.getEncryptedTimestamp();
    }
}

