/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;
import org.apache.directory.server.kerberos.shared.messages.value.flags.TicketFlag;
import org.apache.directory.server.kerberos.shared.messages.value.flags.TicketFlags;

public class TicketFactory {
    private static final int ONE_DAY = 86400000;
    private static final int ONE_WEEK = 604800000;
    private CipherTextHandler cipherTextHandler = new CipherTextHandler();

    public EncryptionKey getServerKey(KerberosPrincipal serverPrincipal, String serverPassword) {
        KerberosKey serverKerberosKey = new KerberosKey(serverPrincipal, serverPassword.toCharArray(), "DES");
        byte[] serverKeyBytes = serverKerberosKey.getEncoded();
        EncryptionKey serverKey = new EncryptionKey(EncryptionType.DES_CBC_MD5, serverKeyBytes);
        return serverKey;
    }

    public Ticket getTicket(KerberosPrincipal clientPrincipal, KerberosPrincipal serverPrincipal, EncryptionKey serverKey) throws KerberosException {
        EncTicketPartModifier encTicketModifier = new EncTicketPartModifier();
        TicketFlags ticketFlags = new TicketFlags();
        ticketFlags.setFlag(TicketFlag.RENEWABLE);
        encTicketModifier.setFlags(ticketFlags);
        EncryptionKey sessionKey = RandomKeyFactory.getRandomKey(EncryptionType.DES_CBC_MD5);
        encTicketModifier.setSessionKey(sessionKey);
        encTicketModifier.setClientPrincipal(clientPrincipal);
        encTicketModifier.setTransitedEncoding(new TransitedEncoding());
        encTicketModifier.setAuthTime(new KerberosTime());
        long now = System.currentTimeMillis();
        KerberosTime endTime = new KerberosTime(now + 86400000L);
        encTicketModifier.setEndTime(endTime);
        KerberosTime renewTill = new KerberosTime(now + 604800000L);
        encTicketModifier.setRenewTill(renewTill);
        EncTicketPart encTicketPart = encTicketModifier.getEncTicketPart();
        EncryptedData encryptedTicketPart = this.cipherTextHandler.seal(serverKey, encTicketPart, KeyUsage.NUMBER2);
        Ticket ticket = new Ticket();
        ticket.setTktVno(5);
        ticket.setServerPrincipal(serverPrincipal);
        ticket.setEncPart(encryptedTicketPart);
        ticket.setEncTicketPart(encTicketPart);
        return ticket;
    }

    public KerberosTicket getKerberosTicket(Ticket ticket) throws IOException {
        byte[] asn1Encoding = TicketEncoder.encodeTicket(ticket);
        KerberosPrincipal client = ticket.getEncTicketPart().getClientPrincipal();
        KerberosPrincipal server = ticket.getServerPrincipal();
        byte[] sessionKey = ticket.getEncTicketPart().getSessionKey().getKeyValue();
        int keyType = ticket.getEncTicketPart().getSessionKey().getKeyType().getOrdinal();
        boolean[] flags = new boolean[32];
        for (int ii = 0; ii < flags.length; ++ii) {
            flags[ii] = ticket.getEncTicketPart().getFlags().isFlagSet(ii);
        }
        Date authTime = ticket.getEncTicketPart().getAuthTime().toDate();
        Date endTime = ticket.getEncTicketPart().getEndTime().toDate();
        Date startTime = ticket.getEncTicketPart().getStartTime() != null ? ticket.getEncTicketPart().getStartTime().toDate() : null;
        Date renewTill = null;
        if (ticket.getEncTicketPart().getFlags().isRenewable()) {
            renewTill = ticket.getEncTicketPart().getRenewTill() != null ? ticket.getEncTicketPart().getRenewTill().toDate() : null;
        }
        InetAddress[] clientAddresses = new InetAddress[]{};
        return new KerberosTicket(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
    }
}

