/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.AddPrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.DeletePrincipal;
import org.apache.directory.server.kerberos.shared.store.operations.GetAllPrincipals;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;

class SingleBaseSearch
implements PrincipalStore {
    private final CoreSession session;

    SingleBaseSearch(DirectoryService directoryService) {
        try {
            this.session = directoryService.getSession();
        }
        catch (Exception e) {
            throw new ServiceConfigurationException("Can't get a session", (Throwable)e);
        }
    }

    public String addPrincipal(PrincipalStoreEntry entry) throws Exception {
        return (String)new AddPrincipal(entry).execute(this.session, null);
    }

    public String deletePrincipal(KerberosPrincipal principal) throws Exception {
        return (String)new DeletePrincipal(principal).execute(this.session, null);
    }

    public PrincipalStoreEntry[] getAllPrincipals(String realm) throws Exception {
        return (PrincipalStoreEntry[])new GetAllPrincipals().execute(this.session, null);
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)new GetPrincipal(principal).execute(this.session, null);
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        return (String)new ChangePassword(principal, newPassword).execute(this.session, null);
    }
}

