/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptedDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.EncryptionTypeDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.HostAddressDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PreAuthenticationDataDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PrincipalNameDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.TicketDecoder;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.KdcOptions;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBody;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBodyModifier;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcRequestDecoder {
    public KdcRequest decode(ByteBuffer in) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(in);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence kdcreq = (DERSequence)app.getObject();
        return this.decodeKdcRequestSequence(kdcreq);
    }

    private KdcRequest decodeKdcRequestSequence(DERSequence sequence) throws IOException {
        int pvno = 5;
        KerberosMessageType msgType = null;
        PaData[] paData = null;
        RequestBody requestBody = null;
        byte[] bodyBytes = null;
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 1: {
                    DERInteger tag1 = (DERInteger)derObject;
                    pvno = tag1.intValue();
                    break;
                }
                case 2: {
                    DERInteger tag2 = (DERInteger)derObject;
                    msgType = KerberosMessageType.getTypeByOrdinal(tag2.intValue());
                    break;
                }
                case 3: {
                    DERSequence tag3 = (DERSequence)derObject;
                    paData = PreAuthenticationDataDecoder.decodeSequence(tag3);
                    break;
                }
                case 4: {
                    DERSequence tag4 = (DERSequence)derObject;
                    requestBody = this.decodeRequestBody(tag4);
                    bodyBytes = object.getOctets();
                }
            }
        }
        return new KdcRequest(pvno, msgType, paData, requestBody, bodyBytes);
    }

    private RequestBody decodeRequestBody(DERSequence sequence) throws IOException {
        RequestBodyModifier modifier = new RequestBodyModifier();
        Enumeration e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    DERBitString kdcOptions = (DERBitString)derObject;
                    modifier.setKdcOptions(new KdcOptions(kdcOptions.getOctets()));
                    break;
                }
                case 1: {
                    DERSequence cName = (DERSequence)derObject;
                    modifier.setClientName(PrincipalNameDecoder.decode(cName));
                    break;
                }
                case 2: {
                    DERGeneralString realm = (DERGeneralString)derObject;
                    modifier.setRealm(realm.getString());
                    break;
                }
                case 3: {
                    DERSequence sname = (DERSequence)derObject;
                    modifier.setServerName(PrincipalNameDecoder.decode(sname));
                    break;
                }
                case 4: {
                    DERGeneralizedTime from = (DERGeneralizedTime)derObject;
                    modifier.setFrom(KerberosTimeDecoder.decode(from));
                    break;
                }
                case 5: {
                    DERGeneralizedTime till = (DERGeneralizedTime)derObject;
                    modifier.setTill(KerberosTimeDecoder.decode(till));
                    break;
                }
                case 6: {
                    DERGeneralizedTime rtime = (DERGeneralizedTime)derObject;
                    modifier.setRtime(KerberosTimeDecoder.decode(rtime));
                    break;
                }
                case 7: {
                    DERInteger nonce = (DERInteger)derObject;
                    modifier.setNonce(nonce.intValue());
                    break;
                }
                case 8: {
                    DERSequence etype = (DERSequence)derObject;
                    modifier.setEType(EncryptionTypeDecoder.decode(etype));
                    break;
                }
                case 9: {
                    DERSequence hostAddresses = (DERSequence)derObject;
                    modifier.setAddresses(HostAddressDecoder.decodeSequence(hostAddresses));
                    break;
                }
                case 10: {
                    DERSequence encryptedData = (DERSequence)derObject;
                    modifier.setEncAuthorizationData(EncryptedDataDecoder.decode(encryptedData));
                    break;
                }
                case 11: {
                    DERSequence tag11 = (DERSequence)derObject;
                    modifier.setAdditionalTickets(TicketDecoder.decodeSequence(tag11));
                }
            }
        }
        return modifier.getRequestBody();
    }
}

