/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.messages.value.types.PaDataType;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaData
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(PaData.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private PaDataType paDataType;
    private byte[] paDataValue;
    private transient int paDataTypeTagLength;
    private transient int paDataValueTagLength;
    private transient int preAuthenticationDataSeqLength;

    public PaData() {
    }

    public PaData(PaDataType paDataType, byte[] paDataValue) {
        this.paDataType = paDataType;
        this.paDataValue = paDataValue;
    }

    public PaDataType getPaDataType() {
        return this.paDataType;
    }

    public void setPaDataType(int paDataType) {
        this.paDataType = PaDataType.getTypeByOrdinal(paDataType);
    }

    public void setPaDataType(PaDataType paDataType) {
        this.paDataType = paDataType;
    }

    public byte[] getPaDataValue() {
        return this.paDataValue;
    }

    public void setPaDataValue(byte[] paDataValue) {
        this.paDataValue = paDataValue;
    }

    public int computeLength() {
        int paDataTypeLength = Value.getNbBytes((int)this.paDataType.getOrdinal());
        this.paDataTypeTagLength = 1 + TLV.getNbBytes((int)paDataTypeLength) + paDataTypeLength;
        this.preAuthenticationDataSeqLength = 1 + TLV.getNbBytes((int)this.paDataTypeTagLength) + this.paDataTypeTagLength;
        this.paDataValueTagLength = this.paDataValue == null ? 2 : 1 + TLV.getNbBytes((int)this.paDataValue.length) + this.paDataValue.length;
        this.preAuthenticationDataSeqLength += 1 + TLV.getNbBytes((int)this.paDataValueTagLength) + this.paDataValueTagLength;
        return 1 + TLV.getNbBytes((int)this.preAuthenticationDataSeqLength) + this.preAuthenticationDataSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.preAuthenticationDataSeqLength));
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.paDataTypeTagLength));
            Value.encode((ByteBuffer)buffer, (int)this.paDataType.getOrdinal());
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.paDataValueTagLength));
            Value.encode((ByteBuffer)buffer, (byte[])this.paDataValue);
        }
        catch (BufferOverflowException boe) {
            log.error("Cannot encode the PreAuthenticationData object, the PDU size is {} when only {} bytes has been allocated", (Object)(1 + TLV.getNbBytes((int)this.preAuthenticationDataSeqLength) + this.preAuthenticationDataSeqLength), (Object)buffer.capacity());
            throw new EncoderException("The PDU buffer size is too small !");
        }
        if (IS_DEBUG) {
            log.debug("PreAuthenticationData encoding : {}", (Object)StringTools.dumpBytes((byte[])buffer.array()));
            log.debug("PreAuthenticationData initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("PreAuthenticationData : {\n");
        sb.append(tabs).append("    padata-type: ").append((Object)this.paDataType).append('\n');
        if (this.paDataValue != null) {
            sb.append(tabs + "    padata-value:").append(StringTools.dumpBytes((byte[])this.paDataValue)).append('\n');
        }
        sb.append(tabs + "}\n");
        return sb.toString();
    }
}

