/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionTypeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBody;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcRequestEncoder {
    public void encode(KdcRequest request, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence kdcRequest = this.encodeInitialSequence(request);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)request.getMessageType().getOrdinal(), (DEREncodable)kdcRequest));
        aos.close();
    }

    private DERSequence encodeInitialSequence(KdcRequest app) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)app.getProtocolVersionNumber())));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERInteger.valueOf((int)app.getMessageType().getOrdinal())));
        if (app.getPreAuthData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)this.encodePreAuthData(app.getPreAuthData())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)this.encodeKdcRequestBody(app.getRequestBody())));
        return sequence;
    }

    public byte[] encodeRequestBody(RequestBody requestBody) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)this.encodeKdcRequestBody(requestBody));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeKdcRequestBody(RequestBody requestBody) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DERBitString(requestBody.getKdcOptions().getBytes())));
        if (requestBody.getClientPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)PrincipalNameEncoder.encode(requestBody.getClientPrincipal())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERGeneralString.valueOf((String)requestBody.getServerPrincipal().getRealm().toString())));
        if (requestBody.getServerPrincipal() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)PrincipalNameEncoder.encode(requestBody.getServerPrincipal())));
        }
        if (requestBody.getFrom() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)KerberosTimeEncoder.encode(requestBody.getFrom())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)KerberosTimeEncoder.encode(requestBody.getTill())));
        if (requestBody.getRtime() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)KerberosTimeEncoder.encode(requestBody.getRtime())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)DERInteger.valueOf((int)requestBody.getNonce())));
        sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)EncryptionTypeEncoder.encode(requestBody.getEType())));
        if (requestBody.getAddresses() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(9, (DEREncodable)HostAddressesEncoder.encodeSequence(requestBody.getAddresses())));
        }
        if (requestBody.getEncAuthorizationData() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(10, (DEREncodable)EncryptedDataEncoder.encodeSequence(requestBody.getEncAuthorizationData())));
        }
        if (requestBody.getAdditionalTickets() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(11, (DEREncodable)TicketEncoder.encodeSequence(requestBody.getAdditionalTickets())));
        }
        return sequence;
    }

    private DERSequence encodePreAuthData(PaData[] preAuthData) {
        DERSequence preAuth = new DERSequence();
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            DERSequence sequence = new DERSequence();
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERInteger.valueOf((int)preAuthData[ii].getPaDataType().getOrdinal())));
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(preAuthData[ii].getPaDataValue())));
            preAuth.add((DEREncodable)sequence);
        }
        return preAuth;
    }
}

