/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared;

import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.KerberosMessageType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.ApplicationRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.server.kerberos.shared.replay.ReplayCache;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosUtils {
    public static final int NULL = -1;
    public static final List<String> EMPTY_PRINCIPAL_NAME = new ArrayList<String>();

    public static List<String> getNames(KerberosPrincipal principal) throws ParseException {
        if (principal == null) {
            return EMPTY_PRINCIPAL_NAME;
        }
        String names = principal.getName();
        if (StringTools.isEmpty((String)names)) {
            return EMPTY_PRINCIPAL_NAME;
        }
        return KerberosUtils.getNames(names);
    }

    public static List<String> getNames(String principalNames) throws ParseException {
        if (principalNames == null) {
            return EMPTY_PRINCIPAL_NAME;
        }
        ArrayList<String> nameComponents = new ArrayList<String>();
        char[] chars = principalNames.toCharArray();
        boolean escaped = false;
        boolean done = false;
        int start = 0;
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            pos = i;
            switch (chars[i]) {
                case '\\': {
                    escaped = !escaped;
                    break;
                }
                case '/': {
                    String nameComponent;
                    if (escaped) {
                        escaped = false;
                        break;
                    }
                    if (i - start > 0) {
                        nameComponent = new String(chars, start, i - start);
                        nameComponents.add(nameComponent);
                        start = i + 1;
                        break;
                    }
                    throw new ParseException("An empty name is not valid in a kerberos name", i);
                }
                case '@': {
                    String nameComponent;
                    if (escaped) {
                        escaped = false;
                        break;
                    }
                    done = true;
                    if (i - start > 0) {
                        nameComponent = new String(chars, start, i - start);
                        nameComponents.add(nameComponent);
                        start = i + 1;
                        break;
                    }
                    throw new ParseException("An empty name is not valid in a kerberos name", i);
                }
            }
            if (done) break;
        }
        if (escaped) {
            throw new ParseException("A '/' at the end of a Kerberos Name is not valid.", pos);
        }
        return nameComponents;
    }

    public static KerberosPrincipal getKerberosPrincipal(PrincipalName principal, String realm) {
        String name = principal.getNameString();
        if (!StringTools.isEmpty((String)realm)) {
            name = name + '@' + realm;
        }
        return new KerberosPrincipal(name, principal.getNameType().getOrdinal());
    }

    public static EncryptionType getBestEncryptionType(Set<EncryptionType> requestedTypes, Set<EncryptionType> configuredTypes) {
        for (EncryptionType encryptionType : requestedTypes) {
            if (!configuredTypes.contains((Object)encryptionType)) continue;
            return encryptionType;
        }
        return null;
    }

    public static String getEncryptionTypesString(Set<EncryptionType> encryptionTypes) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (EncryptionType etype : encryptionTypes) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append((Object)etype);
        }
        return sb.toString();
    }

    public static PrincipalStoreEntry getEntry(KerberosPrincipal principal, PrincipalStore store, ErrorType errorType) throws KerberosException {
        PrincipalStoreEntry entry = null;
        try {
            entry = store.getPrincipal(principal);
        }
        catch (Exception e) {
            throw new KerberosException(errorType, (Throwable)e);
        }
        if (entry == null) {
            throw new KerberosException(errorType);
        }
        if (entry.getKeyMap() == null || entry.getKeyMap().isEmpty()) {
            throw new KerberosException(ErrorType.KDC_ERR_NULL_KEY);
        }
        return entry;
    }

    public static Authenticator verifyAuthHeader(ApplicationRequest authHeader, Ticket ticket, EncryptionKey serverKey, long clockSkew, ReplayCache replayCache, boolean emptyAddressesAllowed, InetAddress clientAddress, CipherTextHandler lockBox, KeyUsage authenticatorKeyUsage, boolean isValidate) throws KerberosException {
        KerberosTime now;
        int clientMicroSeconds;
        KerberosTime clientTime;
        KerberosPrincipal clientPrincipal;
        if (authHeader.getProtocolVersionNumber() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        if (authHeader.getMessageType() != KerberosMessageType.AP_REQ) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_MSG_TYPE);
        }
        if (authHeader.getTicket().getTktVno() != 5) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADVERSION);
        }
        EncryptionKey ticketKey = null;
        ticketKey = authHeader.getOption(1) ? authHeader.getTicket().getEncTicketPart().getSessionKey() : serverKey;
        if (ticketKey == null) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOKEY);
        }
        EncTicketPart encPart = (EncTicketPart)lockBox.unseal(EncTicketPart.class, ticketKey, ticket.getEncPart(), KeyUsage.NUMBER2);
        ticket.setEncTicketPart(encPart);
        Authenticator authenticator = (Authenticator)lockBox.unseal(Authenticator.class, ticket.getEncTicketPart().getSessionKey(), authHeader.getEncPart(), authenticatorKeyUsage);
        if (!authenticator.getClientPrincipal().getName().equals(ticket.getEncTicketPart().getClientPrincipal().getName())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADMATCH);
        }
        if (ticket.getEncTicketPart().getClientAddresses() != null ? !ticket.getEncTicketPart().getClientAddresses().contains(new HostAddress(clientAddress)) : !emptyAddressesAllowed) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BADADDR);
        }
        KerberosPrincipal serverPrincipal = ticket.getServerPrincipal();
        if (replayCache.isReplay(serverPrincipal, clientPrincipal = authenticator.getClientPrincipal(), clientTime = authenticator.getClientTime(), clientMicroSeconds = authenticator.getClientMicroSecond())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_REPEAT);
        }
        replayCache.save(serverPrincipal, clientPrincipal, clientTime, clientMicroSeconds);
        if (!authenticator.getClientTime().isInClockSkew(clockSkew)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_SKEW);
        }
        KerberosTime startTime = ticket.getEncTicketPart().getStartTime() != null ? ticket.getEncTicketPart().getStartTime() : ticket.getEncTicketPart().getAuthTime();
        boolean isValidStartTime = startTime.lessThan(now = new KerberosTime());
        if (!isValidStartTime || ticket.getEncTicketPart().getFlags().isInvalid() && !isValidate) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
        }
        if (!ticket.getEncTicketPart().getEndTime().greaterThan(now)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
        }
        authHeader.setOption(2);
        return authenticator;
    }
}

