/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.TicketFlags;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;

public class Ticket {
    public static final int TICKET_VNO = 5;
    private int versionNumber;
    private KerberosPrincipal serverPrincipal;
    private EncryptedData encPart;
    private EncTicketPart encTicketPart;

    public Ticket(KerberosPrincipal serverPrincipal, EncryptedData encPart) {
        this(5, serverPrincipal, encPart);
    }

    public Ticket(int versionNumber, KerberosPrincipal serverPrincipal, EncryptedData encPart) {
        this.versionNumber = versionNumber;
        this.serverPrincipal = serverPrincipal;
        this.encPart = encPart;
    }

    public void setEncTicketPart(EncTicketPart decryptedPart) {
        this.encTicketPart = decryptedPart;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public KerberosPrincipal getServerPrincipal() {
        return this.serverPrincipal;
    }

    public String getRealm() {
        return this.serverPrincipal.getRealm();
    }

    public EncryptedData getEncPart() {
        return this.encPart;
    }

    public EncTicketPart getEncTicketPart() {
        return this.encTicketPart;
    }

    public AuthorizationData getAuthorizationData() {
        return this.encTicketPart.getAuthorizationData();
    }

    public KerberosTime getAuthTime() {
        return this.encTicketPart.getAuthTime();
    }

    public HostAddresses getClientAddresses() {
        return this.encTicketPart.getClientAddresses();
    }

    public KerberosPrincipal getClientPrincipal() {
        return this.encTicketPart.getClientPrincipal();
    }

    public String getClientRealm() {
        return this.encTicketPart.getClientPrincipal().getRealm();
    }

    public KerberosTime getEndTime() {
        return this.encTicketPart.getEndTime();
    }

    public TicketFlags getFlags() {
        return this.encTicketPart.getFlags();
    }

    public KerberosTime getRenewTill() {
        return this.encTicketPart.getRenewTill();
    }

    public EncryptionKey getSessionKey() {
        return this.encTicketPart.getSessionKey();
    }

    public KerberosTime getStartTime() {
        return this.encTicketPart.getStartTime();
    }

    public TransitedEncoding getTransitedEncoding() {
        return this.encTicketPart.getTransitedEncoding();
    }

    public boolean getFlag(int flag) {
        return this.encTicketPart.getFlags().get(flag);
    }
}

