/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionTypeInfoEntry;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionTypeInfoEncoder {
    public static byte[] encode(EncryptionTypeInfoEntry[] entries) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)EncryptionTypeInfoEncoder.encodeSequence(entries));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(EncryptionTypeInfoEntry[] entries) {
        DERSequence sequence = new DERSequence();
        for (int ii = 0; ii < entries.length; ++ii) {
            sequence.add((DEREncodable)EncryptionTypeInfoEncoder.encode(entries[ii]));
        }
        return sequence;
    }

    protected static DERSequence encode(EncryptionTypeInfoEntry entry) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)entry.getEncryptionType().getOrdinal())));
        if (entry.getSalt() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)new DEROctetString(entry.getSalt())));
        }
        return sequence;
    }
}

