/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumEngine;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

public abstract class EncryptionEngine {
    private static final SecureRandom random = new SecureRandom();

    public abstract ChecksumEngine getChecksumEngine();

    public abstract Cipher getCipher() throws GeneralSecurityException;

    public abstract EncryptionType encryptionType();

    public abstract ChecksumType checksumType();

    public abstract CipherType keyType();

    public abstract int confounderSize();

    public abstract int checksumSize();

    public abstract int blockSize();

    public abstract int minimumPadSize();

    public abstract int keySize();

    public byte[] getDecryptedData(EncryptionKey key, EncryptedData data) throws KerberosException {
        byte[] decryptedData = this.decrypt(data.getCipherText(), key.getKeyValue());
        byte[] oldChecksum = new byte[this.checksumSize()];
        System.arraycopy(decryptedData, this.confounderSize(), oldChecksum, 0, oldChecksum.length);
        for (int i = this.confounderSize(); i < this.confounderSize() + this.checksumSize(); ++i) {
            decryptedData[i] = 0;
        }
        byte[] newChecksum = this.calculateChecksum(decryptedData);
        if (!Arrays.equals(oldChecksum, newChecksum)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY);
        }
        return this.removeBytes(decryptedData, this.confounderSize(), this.checksumSize());
    }

    public EncryptedData getEncryptedData(EncryptionKey key, byte[] plainText) {
        byte[] conFounder = this.getRandomBytes(this.confounderSize());
        byte[] zeroedChecksum = new byte[this.checksumSize()];
        byte[] paddedPlainText = this.padString(plainText);
        byte[] dataBytes = this.concatenateBytes(conFounder, this.concatenateBytes(zeroedChecksum, paddedPlainText));
        byte[] checksumBytes = this.calculateChecksum(dataBytes);
        byte[] paddedDataBytes = this.padString(dataBytes);
        for (int i = this.confounderSize(); i < this.confounderSize() + this.checksumSize(); ++i) {
            paddedDataBytes[i] = checksumBytes[i - this.confounderSize()];
        }
        byte[] encryptedData = this.encrypt(paddedDataBytes, key.getKeyValue());
        return new EncryptedData(this.encryptionType(), key.getKeyVersion(), encryptedData);
    }

    private byte[] encrypt(byte[] data, byte[] key) {
        return this.processCipher(true, data, key);
    }

    private byte[] decrypt(byte[] data, byte[] key) {
        return this.processCipher(false, data, key);
    }

    private byte[] getRandomBytes(int size) {
        byte[] bytes = new byte[size];
        random.nextBytes(bytes);
        return bytes;
    }

    private byte[] padString(byte[] encodedString) {
        int x = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (x == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - x + encodedString.length];
        for (int y = paddedByteArray.length - 1; y > encodedString.length - 1; --y) {
            paddedByteArray[y] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }

    private byte[] concatenateBytes(byte[] array1, byte[] array2) {
        byte[] concatenatedBytes = new byte[array1.length + array2.length];
        for (int i = 0; i < array1.length; ++i) {
            concatenatedBytes[i] = array1[i];
        }
        for (int j = array1.length; j < concatenatedBytes.length; ++j) {
            concatenatedBytes[j] = array2[j - array1.length];
        }
        return concatenatedBytes;
    }

    private byte[] calculateChecksum(byte[] data) {
        ChecksumEngine digester = this.getChecksumEngine();
        return digester.calculateChecksum(data);
    }

    private byte[] removeBytes(byte[] array, int confounder, int checksum) {
        byte[] lessBytes = new byte[array.length - confounder - checksum];
        int j = 0;
        for (int i = confounder + checksum; i < array.length; ++i) {
            lessBytes[j] = array[i];
            ++j;
        }
        return lessBytes;
    }

    private byte[] processCipher(boolean encrypt, byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = this.getCipher();
            SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            if (encrypt) {
                cipher.init(1, (Key)key, paramSpec);
            } else {
                cipher.init(2, (Key)key, paramSpec);
            }
            byte[] finalBytes = cipher.doFinal(data);
            return finalBytes;
        }
        catch (GeneralSecurityException nsae) {
            return null;
        }
    }
}

