/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KdcOptions;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBody;

public class RequestBodyModifier {
    private KerberosPrincipalModifier clientModifier = new KerberosPrincipalModifier();
    private KerberosPrincipalModifier serverModifier = new KerberosPrincipalModifier();
    private KdcOptions kdcOptions;
    private KerberosTime from;
    private KerberosTime till;
    private KerberosTime rtime;
    private int nonce;
    private EncryptionType[] eType;
    private HostAddresses addresses;
    private EncryptedData encAuthorizationData;
    private Ticket[] additionalTickets;

    public RequestBody getRequestBody() {
        KerberosPrincipal clientPrincipal = this.clientModifier.getKerberosPrincipal();
        KerberosPrincipal serverPrincipal = this.serverModifier.getKerberosPrincipal();
        return new RequestBody(this.kdcOptions, clientPrincipal, serverPrincipal, this.from, this.till, this.rtime, this.nonce, this.eType, this.addresses, this.encAuthorizationData, this.additionalTickets);
    }

    public void setClientName(PrincipalName clientName) {
        this.clientModifier.setPrincipalName(clientName);
    }

    public void setServerName(PrincipalName serverName) {
        this.serverModifier.setPrincipalName(serverName);
    }

    public void setRealm(String realm) {
        this.clientModifier.setRealm(realm);
        this.serverModifier.setRealm(realm);
    }

    public void setAdditionalTickets(Ticket[] tickets) {
        this.additionalTickets = tickets;
    }

    public void setAddresses(HostAddresses addresses) {
        this.addresses = addresses;
    }

    public void setEncAuthorizationData(EncryptedData authorizationData) {
        this.encAuthorizationData = authorizationData;
    }

    public void setEType(EncryptionType[] type) {
        this.eType = type;
    }

    public void setFrom(KerberosTime from) {
        this.from = from;
    }

    public void setKdcOptions(KdcOptions options) {
        this.kdcOptions = options;
    }

    public void setNonce(int nonce) {
        this.nonce = nonce;
    }

    public void setRtime(KerberosTime rtime) {
        this.rtime = rtime;
    }

    public void setTill(KerberosTime till) {
        this.till = till;
    }
}

