/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.checksum;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherType;

public abstract class ChecksumEngine {
    public abstract MessageDigest getDigest() throws NoSuchAlgorithmException;

    public abstract ChecksumType checksumType();

    public abstract CipherType keyType();

    public abstract int checksumSize();

    public abstract int keySize();

    public abstract int confounderSize();

    public abstract boolean isSafe();

    public abstract byte[] calculateKeyedChecksum(byte[] var1, byte[] var2);

    public abstract boolean verifyKeyedChecksum(byte[] var1, byte[] var2, byte[] var3);

    public byte[] calculateChecksum(byte[] data) {
        try {
            MessageDigest digester = this.getDigest();
            return digester.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }
}

