/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionKeyEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.LastRequestEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcReply;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public abstract class EncKdcRepPartEncoder
implements Encoder {
    private int applicationCode;

    protected EncKdcRepPartEncoder(int applicationCode) {
        this.applicationCode = applicationCode;
    }

    public byte[] encode(Encodable app) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence initialSequence = this.encodeInitialSequence((KdcReply)app);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)this.applicationCode, (DEREncodable)initialSequence));
        return baos.toByteArray();
    }

    protected DERSequence encodeInitialSequence(KdcReply reply) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)EncryptionKeyEncoder.encode(reply.getKey())));
        sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)LastRequestEncoder.encode(reply.getLastRequest())));
        sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERInteger.valueOf((int)reply.getNonce())));
        if (reply.getKeyExpiration() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)KerberosTimeEncoder.encode(reply.getKeyExpiration())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)new DERBitString(reply.getFlags().getBytes())));
        sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)KerberosTimeEncoder.encode(reply.getAuthTime())));
        if (reply.getStartTime() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(6, (DEREncodable)KerberosTimeEncoder.encode(reply.getStartTime())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(7, (DEREncodable)KerberosTimeEncoder.encode(reply.getEndTime())));
        if (reply.getRenewTill() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(8, (DEREncodable)KerberosTimeEncoder.encode(reply.getRenewTill())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(9, (DEREncodable)DERGeneralString.valueOf((String)reply.getServerRealm().toString())));
        sequence.add((DEREncodable)new DERTaggedObject(10, (DEREncodable)PrincipalNameEncoder.encode(reply.getServerPrincipal())));
        if (reply.getClientAddresses() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(11, (DEREncodable)HostAddressesEncoder.encodeSequence(reply.getClientAddresses())));
        }
        return sequence;
    }
}

