/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.checksum;

import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherType;
import org.bouncycastle.crypto.Digest;

public abstract class ChecksumEngine {
    public abstract Digest getDigest();

    public abstract ChecksumType checksumType();

    public abstract CipherType keyType();

    public abstract int checksumSize();

    public abstract int keySize();

    public abstract int confounderSize();

    public abstract boolean isSafe();

    public abstract byte[] calculateKeyedChecksum(byte[] var1, byte[] var2);

    public abstract boolean verifyKeyedChecksum(byte[] var1, byte[] var2, byte[] var3);

    public byte[] calculateChecksum(byte[] data) {
        Digest digester = this.getDigest();
        digester.reset();
        digester.update(data, 0, data.length);
        byte[] returnValue = new byte[digester.getDigestSize()];
        digester.doFinal(returnValue, 0);
        return returnValue;
    }
}

