/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PrincipalNameType
implements Comparable {
    public static final PrincipalNameType KRB_NT_UNKNOWN = new PrincipalNameType(0, "unknown name type");
    public static final PrincipalNameType KRB_NT_PRINCIPAL = new PrincipalNameType(1, "user principal name type");
    public static final PrincipalNameType KRB_NT_SRV_INST = new PrincipalNameType(2, "service and other unique instance (krbtgt) name type");
    public static final PrincipalNameType KRB_NT_SRV_HST = new PrincipalNameType(3, "service with host name as instance (telnet, rcommands)");
    public static final PrincipalNameType KRB_NT_SRV_XHST = new PrincipalNameType(4, "service with host name as instance (telnet, rcommands) name type");
    public static final PrincipalNameType KRB_NT_UID = new PrincipalNameType(5, "unique ID name type");
    public static final PrincipalNameType KRB_NT_X500_PRINCIPAL = new PrincipalNameType(6, "nt x500 principal; encoded X.509 Distinguished name [RFC 2253]");
    private final String name;
    private final int ordinal;
    private static final PrincipalNameType[] values = new PrincipalNameType[]{KRB_NT_UNKNOWN, KRB_NT_PRINCIPAL, KRB_NT_SRV_INST, KRB_NT_SRV_HST, KRB_NT_SRV_XHST, KRB_NT_UID, KRB_NT_X500_PRINCIPAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(values));

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }

    public int compareTo(Object that) {
        return this.ordinal - ((PrincipalNameType)that).ordinal;
    }

    public static PrincipalNameType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (PrincipalNameType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return KRB_NT_UNKNOWN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    private PrincipalNameType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }
}

