/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.server.kerberos.shared.crypto.encryption.ArcFourHmacMd5Encryption;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionEngine;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherTextHandler {
    private static final Logger LOG_KRB = LoggerFactory.getLogger((String)Loggers.KERBEROS_LOG.getName());
    private static final Map<EncryptionType, Class<? extends EncryptionEngine>> DEFAULT_CIPHERS;

    public EncryptedData seal(EncryptionKey key, Asn1Object message, KeyUsage usage) throws KerberosException {
        try {
            int bufferSize = message.computeLength();
            ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
            byte[] encoded = message.encode(buffer).array();
            return this.encrypt(key, encoded, usage);
        }
        catch (EncoderException ioe) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)ioe);
        }
        catch (ClassCastException cce) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_BAD_INTEGRITY, (Throwable)cce);
        }
    }

    public EncryptedData encrypt(EncryptionKey key, byte[] plainText, KeyUsage usage) throws KerberosException {
        EncryptionEngine engine = this.getEngine(key);
        return engine.getEncryptedData(key, plainText, usage);
    }

    public byte[] decrypt(EncryptionKey key, EncryptedData data, KeyUsage usage) throws KerberosException {
        LOG_KRB.debug("Decrypting data using key {} and usage {}", (Object)key.getKeyType(), (Object)usage);
        EncryptionEngine engine = this.getEngine(key);
        return engine.getDecryptedData(key, data, usage);
    }

    private EncryptionEngine getEngine(EncryptionKey key) throws KerberosException {
        EncryptionType encryptionType = key.getKeyType();
        Class<? extends EncryptionEngine> clazz = DEFAULT_CIPHERS.get((Object)encryptionType);
        if (clazz == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP);
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, (Throwable)ie);
        }
    }

    static {
        EnumMap<EncryptionType, Class<ArcFourHmacMd5Encryption>> map = new EnumMap<EncryptionType, Class<ArcFourHmacMd5Encryption>>(EncryptionType.class);
        map.put(EncryptionType.RC4_HMAC, ArcFourHmacMd5Encryption.class);
        DEFAULT_CIPHERS = Collections.unmodifiableMap(map);
    }
}

