/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.protocol;

import java.io.IOException;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class KerberosEncoder
extends ProtocolEncoderAdapter {
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws IOException {
        AbstractAsn1Object asn1Obj = (AbstractAsn1Object)message;
        boolean isTcp = !session.getTransportMetadata().isConnectionless();
        IoBuffer response = null;
        IoBuffer kerberosMessage = null;
        int responseLength = asn1Obj.computeLength();
        kerberosMessage = IoBuffer.allocate((int)responseLength);
        response = isTcp ? IoBuffer.allocate((int)(responseLength + 4)) : kerberosMessage;
        try {
            asn1Obj.encode(kerberosMessage.buf());
            if (isTcp) {
                response.putInt(responseLength);
                response.put(kerberosMessage.buf().array());
            }
            response.flip();
            out.write((Object)response);
        }
        catch (EncoderException e) {
            throw new IOException(e.getMessage());
        }
    }
}

