/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.util.ArrayList;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.kerberos.shared.store.operations.StoreUtils;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.util.Strings;

public class ChangePassword
implements DirectoryServiceOperation {
    protected KerberosPrincipal principal;
    protected String newPassword;

    public ChangePassword(KerberosPrincipal principal, String newPassword) {
        this.principal = principal;
        this.newPassword = newPassword;
    }

    public Object execute(CoreSession session, Dn searchBaseDn) throws Exception {
        if (this.principal == null) {
            return null;
        }
        SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
        ArrayList<DefaultModification> mods = new ArrayList<DefaultModification>(2);
        DefaultAttribute newPasswordAttribute = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("userPassword"), (byte[][])new byte[][]{Strings.getBytesUtf8((String)this.newPassword)});
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)newPasswordAttribute));
        DefaultAttribute principalAttribute = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("krb5PrincipalName"), new String[]{this.principal.getName()});
        mods.add(new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)principalAttribute));
        Entry entry = StoreUtils.findPrincipalEntry(session, searchBaseDn, this.principal.getName());
        session.modify(entry.getDn(), mods);
        return entry.getDn().toString();
    }
}

