/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import java.util.Map;
import javax.naming.NamingException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.store.KerberosCatalog;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.server.protocol.shared.catalog.Catalog;
import org.apache.directory.server.protocol.shared.catalog.GetCatalog;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;

class MultiBaseSearch
implements PrincipalStore {
    private final Catalog catalog;
    private final DirectoryService directoryService;

    MultiBaseSearch(String catalogBaseDn, DirectoryService directoryService) {
        this.directoryService = directoryService;
        try {
            this.catalog = new KerberosCatalog((Map)this.execute(directoryService.getSession(), (DirectoryServiceOperation)new GetCatalog()));
        }
        catch (Exception e) {
            String message = I18n.err((I18n)I18n.ERR_624, (Object[])new Object[]{catalogBaseDn});
            throw new ServiceConfigurationException(message, (Throwable)e);
        }
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        try {
            return (PrincipalStoreEntry)this.execute(this.directoryService.getSession(), new GetPrincipal(principal));
        }
        catch (NamingException ne) {
            String message = I18n.err((I18n)I18n.ERR_625, (Object[])new Object[]{principal.getRealm()});
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        try {
            return (String)this.execute(this.directoryService.getSession(), new ChangePassword(principal, newPassword));
        }
        catch (NamingException ne) {
            String message = I18n.err((I18n)I18n.ERR_625, (Object[])new Object[]{principal.getRealm()});
            throw new ServiceConfigurationException(message, (Throwable)ne);
        }
    }

    private Object execute(CoreSession session, DirectoryServiceOperation operation) throws Exception {
        return operation.execute(session, null);
    }
}

