/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.i18n.I18n;

public final class Provider
implements RecordManagerProvider {
    public RecordManager createRecordManager(String name, Properties options) throws IOException {
        RecordManager recman = new BaseRecordManager(name);
        String value = options.getProperty("jdbm.disableTransactions", "false");
        if (value.equalsIgnoreCase("TRUE")) {
            recman.disableTransactions();
        }
        value = options.getProperty("jdbm.cache.size", "1000");
        int cacheSize = Integer.parseInt(value);
        value = options.getProperty("jdbm.cache.type", "normal");
        if (!value.equalsIgnoreCase("normal")) {
            if (value.equalsIgnoreCase("soft")) {
                throw new IllegalArgumentException(I18n.err((String)I18n.ERR_551, (Object[])new Object[0]));
            }
            if (value.equalsIgnoreCase("weak")) {
                throw new IllegalArgumentException(I18n.err((String)I18n.ERR_552, (Object[])new Object[0]));
            }
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_553, (Object[])new Object[]{value}));
        }
        MRU cache = new MRU(cacheSize);
        recman = new CacheRecordManager(recman, cache);
        return recman;
    }
}

