/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import jdbm.helper.Serialization;
import jdbm.helper.WrappedRuntimeException;
import org.apache.directory.server.i18n.I18n;

public final class ObjectBAComparator
implements Comparator,
Serializable {
    static final long serialVersionUID = 1L;
    private Comparator _comparator;

    public ObjectBAComparator(Comparator comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_518, (Object[])new Object[0]));
        }
        this._comparator = comparator;
    }

    public int compare(Object obj1, Object obj2) {
        if (obj1 == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_525, (Object[])new Object[0]));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(I18n.err((String)I18n.ERR_526, (Object[])new Object[0]));
        }
        try {
            obj1 = Serialization.deserialize((byte[])obj1);
            obj2 = Serialization.deserialize((byte[])obj2);
            return this._comparator.compare(obj1, obj2);
        }
        catch (IOException except) {
            throw new WrappedRuntimeException(except);
        }
        catch (ClassNotFoundException except) {
            throw new WrappedRuntimeException(except);
        }
    }

    public static int compareByteArray(byte[] thisKey, byte[] otherKey) {
        int len = Math.min(thisKey.length, otherKey.length);
        for (int i = 0; i < len; ++i) {
            if (thisKey[i] >= 0) {
                if (otherKey[i] >= 0) {
                    if (thisKey[i] < otherKey[i]) {
                        return -1;
                    }
                    if (thisKey[i] <= otherKey[i]) continue;
                    return 1;
                }
                return -1;
            }
            if (otherKey[i] >= 0) {
                return 1;
            }
            if (thisKey[i] < otherKey[i]) {
                return -1;
            }
            if (thisKey[i] <= otherKey[i]) continue;
            return 1;
        }
        if (thisKey.length == otherKey.length) {
            return 0;
        }
        if (thisKey.length < otherKey.length) {
            return -1;
        }
        return 1;
    }
}

