/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Enumeration;
import jdbm.RecordManager;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.WrappedRuntimeException;

public class CacheRecordManager
implements RecordManager {
    protected RecordManager _recman;
    protected CachePolicy _cache;

    public CacheRecordManager(RecordManager recman, CachePolicy cache) {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        this._recman = recman;
        this._cache = cache;
        this._cache.addListener(new CacheListener());
    }

    public RecordManager getRecordManager() {
        return this._recman;
    }

    public CachePolicy getCachePolicy() {
        return this._cache;
    }

    public long insert(Object obj) throws IOException {
        return this.insert(obj, DefaultSerializer.INSTANCE);
    }

    public synchronized long insert(Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        long recid = this._recman.insert(obj, serializer);
        try {
            this._cache.put(new Long(recid), new CacheEntry(recid, obj, serializer, false));
        }
        catch (CacheEvictionException except) {
            throw new WrappedRuntimeException(except);
        }
        return recid;
    }

    public synchronized void delete(long recid) throws IOException {
        this.checkIfClosed();
        this._recman.delete(recid);
        this._cache.remove(new Long(recid));
    }

    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, DefaultSerializer.INSTANCE);
    }

    public synchronized void update(long recid, Object obj, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long id = new Long(recid);
        try {
            CacheEntry entry = (CacheEntry)this._cache.get(id);
            if (entry != null) {
                entry._obj = obj;
                entry._serializer = serializer;
                entry._isDirty = true;
            } else {
                this._cache.put(id, new CacheEntry(recid, obj, serializer, true));
            }
        }
        catch (CacheEvictionException except) {
            throw new IOException(except.getMessage());
        }
    }

    public Object fetch(long recid) throws IOException {
        return this.fetch(recid, DefaultSerializer.INSTANCE);
    }

    public synchronized Object fetch(long recid, Serializer serializer) throws IOException {
        this.checkIfClosed();
        Long id = new Long(recid);
        CacheEntry entry = (CacheEntry)this._cache.get(id);
        if (entry == null) {
            entry = new CacheEntry(recid, null, serializer, false);
            entry._obj = this._recman.fetch(recid, serializer);
            try {
                this._cache.put(id, entry);
            }
            catch (CacheEvictionException except) {
                throw new WrappedRuntimeException(except);
            }
        }
        return entry._obj;
    }

    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.close();
        this._recman = null;
        this._cache = null;
    }

    public synchronized int getRootCount() {
        this.checkIfClosed();
        return this._recman.getRootCount();
    }

    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this._recman.getRoot(id);
    }

    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this._recman.setRoot(id, rowid);
    }

    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this.updateCacheEntries();
        this._recman.commit();
    }

    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._recman.rollback();
        this._cache.removeAll();
    }

    public synchronized long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        return this._recman.getNamedObject(name);
    }

    public synchronized void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        this._recman.setNamedObject(name, recid);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._recman == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }

    protected void updateCacheEntries() throws IOException {
        Enumeration enume = this._cache.elements();
        while (enume.hasMoreElements()) {
            CacheEntry entry = (CacheEntry)enume.nextElement();
            if (!entry._isDirty) continue;
            this._recman.update(entry._recid, entry._obj, entry._serializer);
            entry._isDirty = false;
        }
    }

    private class CacheListener
    implements CachePolicyListener {
        private CacheListener() {
        }

        public void cacheObjectEvicted(Object obj) throws CacheEvictionException {
            CacheEntry entry = (CacheEntry)obj;
            if (entry._isDirty) {
                try {
                    CacheRecordManager.this._recman.update(entry._recid, entry._obj, entry._serializer);
                }
                catch (IOException except) {
                    throw new CacheEvictionException(except);
                }
            }
        }
    }

    private class CacheEntry {
        long _recid;
        Object _obj;
        Serializer _serializer;
        boolean _isDirty;

        CacheEntry(long recid, Object obj, Serializer serializer, boolean isDirty) {
            this._recid = recid;
            this._obj = obj;
            this._serializer = serializer;
            this._isDirty = isDirty;
        }
    }
}

